// BuildDialog.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "OptionsSheet.h"
#include "BuildDialog.h"
#include ".\builddialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBuildDialog dialog


CBuildDialog::CBuildDialog(CWnd* pParent)
	: CPropertyPage(CBuildDialog::IDD)
{
	//{{AFX_DATA_INIT(CBuildDialog)
	m_bDebugging = false;
	m_bExceptions = false;
	m_bRTTI = false;
	m_bStrict = true;
	m_bC99 = false;
	m_bWarnType = -1;
	m_strDefine = _T("");
	m_strInclude = _T("");
	m_strLib = _T("");
	m_strCmdLineOptions = _T("");
	m_strLinkerOptions = _T("");
	//}}AFX_DATA_INIT
	m_nOptimize = 0;
}


void CBuildDialog::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBuildDialog)
	DDX_Control(pDX, IDC_RTTI, m_RTTIbutton);
	DDX_Check(pDX, IDC_DEBUG, m_bDebugging);
	DDX_Check(pDX, IDC_EXCEPTIONS, m_bExceptions);
	DDX_Check(pDX, IDC_RTTI, m_bRTTI);
	DDX_Check(pDX, IDC_STRICT, m_bStrict);
	DDX_Check(pDX, IDC_C99, m_bC99);
	DDX_Radio(pDX, IDC_DEFLTWARN, m_bWarnType);
	DDX_Text(pDX, IDC_DEFINE, m_strDefine);
	DDX_Text(pDX, IDC_INCLUDE, m_strInclude);
	DDX_Text(pDX, IDC_LIB, m_strLib);
	DDX_Text(pDX, IDC_EDIT1, m_strCompiler);
	DDX_Control(pDX, IDC_OPTIMIZE, m_Optimize);
	DDX_Control(pDX, IDC_OPTIMIZESPIN, m_OptimizeSpin);
	DDX_Text(pDX, IDC_CMDLINEOPTIONS, m_strCmdLineOptions);
	DDX_Text(pDX, IDC_LINKEROPTIONS, m_strLinkerOptions);

	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBuildDialog, CPropertyPage)
	//{{AFX_MSG_MAP(CBuildDialog)
	ON_BN_CLICKED(IDC_DEBUG, OnDebug)
	ON_BN_CLICKED(IDC_EXCEPTIONS, OnExceptions)
	ON_BN_CLICKED(IDC_BROWSEINCLUDES, OnBrowseincludes)
	ON_BN_CLICKED(IDC_BROWSELIBRARIES, OnBrowselibraries)
	ON_BN_CLICKED(IDC_BROWSECOMPILER, OnBrowsecompiler)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_DEFLTWARN, OnBnClickedDefltwarn)
	ON_EN_CHANGE(IDC_OPTIMIZE, OnEnChangeOptimize)
	ON_BN_CLICKED(IDC_ALLWARN, OnBnClickedAllwarn)
	ON_BN_CLICKED(IDC_WARNINGS, OnBnClickedWarnings)
	ON_BN_CLICKED(IDC_C99, OnBnClickedC99)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBuildDialog message handlers
BOOL CBuildDialog::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	m_OptimizeSpin.SetRange(0, 4);
	OnDebug();
	OnExceptions();
	return true;
}

void CBuildDialog::OnDebug() 
{
	UpdateData();
	if (m_bDebugging)	{
		m_OptimizeSpin.SetPos(0);
		m_Optimize.EnableWindow(false);
		m_OptimizeSpin.EnableWindow(false);
	}
	else	{
		m_Optimize.EnableWindow();
		m_OptimizeSpin.EnableWindow();
		m_OptimizeSpin.SetPos(m_nOptimize);
	}
}

void CBuildDialog::OnExceptions() 
{
	UpdateData();
	if (m_bExceptions)	{
		m_RTTIbutton.SetCheck(1);
		m_RTTIbutton.EnableWindow(false);
	}
	else
		m_RTTIbutton.EnableWindow();
}

void CBuildDialog::OnOK() 
{
	UpdateData();
	m_nOptimize = m_OptimizeSpin.GetPos();
	CPropertyPage::OnOK();
}

BOOL CBuildDialog::OnSetActive() 
{
	static_cast<COptionsSheet*>(GetParent())->RegisterActiveIndex();
	return CPropertyPage::OnSetActive();
}


void CBuildDialog::OnBrowseincludes() 
{
	CString includes;
	if (theApp.SelectFolder("#include Headers", &includes))	{
		if (!m_strInclude.IsEmpty())
			m_strInclude += ';';
		m_strInclude += includes;
		UpdateData(0);
	}
}

void CBuildDialog::OnBrowselibraries() 
{
	CString libraries;
	if (theApp.SelectFolder("#include Headers", &libraries))	{
		if (!m_strLib.IsEmpty())
			m_strLib += ';';
		m_strLib += libraries;
		UpdateData(0);
	}
}

void CBuildDialog::OnBrowsecompiler() 
{
	if (theApp.SelectFolder("Compiler", &m_strCompiler))
		UpdateData(0);
}


void CBuildDialog::OnBnClickedDefltwarn()
{
	// TODO: Add your control notification handler code here
}

void CBuildDialog::OnEnChangeOptimize()
{
	// TODO:  If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CPropertyPage::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.

	// TODO:  Add your control notification handler code here
}

void CBuildDialog::OnBnClickedAllwarn()
{
	// TODO: Add your control notification handler code here
}

void CBuildDialog::OnBnClickedWarnings()
{
	// TODO: Add your control notification handler code here
}

void CBuildDialog::OnBnClickedC99()
{
	// TODO: Add your control notification handler code here
}
