// ChildFrm.cpp : implementation of the CChildFrame class
//

#include "stdafx.h"
#include "Quincy.h"
#include "compiler.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "EditorDoc.h"
#include "resource.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CChildFrame classes

IMPLEMENT_DYNCREATE(CChildFrame, CMDIChildWnd)

BEGIN_MESSAGE_MAP(CChildFrame, CMDIChildWnd)
	ON_WM_CONTEXTMENU()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CChildFrame construction/destruction

CChildFrame::CChildFrame()
{
	m_pview = 0;
}

CChildFrame::~CChildFrame()
{
}

/////////////////////////////////////////////////////////////////////////////
// CChildFrame message handlers


void CChildFrame::OnContextMenu(CWnd *pWnd, CPoint point)
{
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_MAINFRAME));
	UINT action;

	if (m_pview != 0)	{
		CMenu* pPopup;
		CQuincyView* docview = dynamic_cast<CQuincyView*>(m_pview);
		if (docview)	{
			pPopup = menu.GetSubMenu(3);
			ASSERT(pPopup != 0);
			// ---- if the project has no files, disable Build, Build All, and Execute
			Debugger* pDebugger = theApp.GetDebugger(FALSE);
			action = (docview->GetItemCount() != 0 && !theApp.CompileRunning() && theApp.CanCompile() && pDebugger == 0)
				? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_BUILD,action);
			pPopup->EnableMenuItem(ID_BUILDALL,action);
			pPopup->EnableMenuItem(ID_EXECUTE,action);
			action = (theApp.CompileRunning() || pDebugger != 0) ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_STOPBUILD,action);

			// ---- if the project has no selected files, disable Delete
			action = docview->GetSelectedCount() == 0 ? MF_DISABLED | MF_GRAYED : MF_ENABLED;
			pPopup->EnableMenuItem(ID_DELETE_FILE,action);

			// ---- can't compile or link from the project view
			pPopup->EnableMenuItem(ID_COMPILE, MF_DISABLED | MF_GRAYED);
			pPopup->EnableMenuItem(ID_PROJECT_LINK, MF_DISABLED | MF_GRAYED);
		}
		else	{
			CEditorView* editorview = dynamic_cast<CEditorView*>(m_pview);
			ASSERT(editorview);
			pPopup = menu.GetSubMenu(1);
			ASSERT(pPopup != 0);

			action = editorview->IsFindText() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_FIND_NEXT, action);
			action = editorview->IsSelectionMarked() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_CUT, action);
			pPopup->EnableMenuItem(ID_EDIT_COPY, action);
			action = editorview->IsSelectionMarked() || !editorview->IsRecording() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_CLEAR, action);
			action = IsClipboardFormatAvailable(CF_TEXT) ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_PASTE, action);
			action = editorview->GetDocument()->CanUndo() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_UNDO, action);
			action = editorview->GetDocument()->CanRedo() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_EDIT_REDO, action);
			action = editorview->CanMatchBraces() ? MF_ENABLED : MF_DISABLED | MF_GRAYED;
			pPopup->EnableMenuItem(ID_BRACEMATCH, action);
		}
		// ---- display and track the popup menu, sending commands to the view object
		pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON, point.x, point.y, pWnd);
	}
}



