// ProjectDlg.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "ProjectDlg.h"
#include ".\projectdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ProjectDlg dialog


ProjectDlg::ProjectDlg(CWnd* pParent)
	: CDialog(ProjectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(ProjectDlg)
	m_nProjectType = 0;
	m_bWithConsole = true;
	m_bFLTK_Forms = false;
	m_bFLTK_OpenGL = false;
	m_bFLTK_Images = false;
	m_strTarget = _T("");
	m_strWorking = _T("");
	m_strPath = _T("");
	//}}AFX_DATA_INIT
}


void ProjectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ProjectDlg)
	DDX_Control(pDX, IDC_BROWSEPROJECT, m_browseproject);
	DDX_Control(pDX, IDC_TARGET, m_target);
	DDX_Control(pDX, IDC_PROJPATH, m_projectpath);
	DDX_Control(pDX, IDC_WITH_CONSOLE, m_WCONSLbutton);
	DDX_Control(pDX, IDC_CHECK_FORMS, m_FLTK_Forms_button);
	DDX_Control(pDX, IDC_CHECK_GL, m_FLTK_OpenGL_button);
	DDX_Control(pDX, IDC_CHECK_IMG, m_FLTK_Images_button);
	DDX_Check(pDX, IDC_WITH_CONSOLE, m_bWithConsole);
	DDX_Check(pDX, IDC_CHECK_FORMS, m_bFLTK_Forms);
	DDX_Check(pDX, IDC_CHECK_GL, m_bFLTK_OpenGL);
	DDX_Check(pDX, IDC_CHECK_IMG, m_bFLTK_Images);
	DDX_Radio(pDX, IDC_CONSOLE, m_nProjectType);
	DDX_Text(pDX, IDC_TARGET, m_strTarget);
	DDX_Text(pDX, IDC_WORKING, m_strWorking);
	DDX_Text(pDX, IDC_PROJPATH, m_strPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ProjectDlg, CDialog)
	//{{AFX_MSG_MAP(ProjectDlg)
	ON_BN_CLICKED(IDC_BROWSEWORKING, OnBrowseworking)
	ON_BN_CLICKED(IDC_BROWSEPROJECT, OnBrowseproject)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_DLL, OnBnClickedDll)
	ON_BN_CLICKED(IDC_GUI, OnBnClickedGui)
	ON_BN_CLICKED(IDC_CONSOLE, OnBnClickedConsole)
	ON_BN_CLICKED(IDC_FLTK, OnBnClickedFltk)
	ON_BN_CLICKED(IDC_BGI, OnBnClickedBgi)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
	ON_BN_CLICKED(IDC_KOOLPLOT, OnBnClickedKoolplot)
	ON_BN_CLICKED(IDC_WITH_CONSOLE, OnBnClickedWConsole)
	ON_BN_CLICKED(IDC_LIBRARY, OnBnClickedLibrary)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ProjectDlg message handlers

BOOL ProjectDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	if (!m_strTarget.IsEmpty())	{
		m_projectpath.EnableWindow(false);
		m_browseproject.EnableWindow(false);
	}
	// Enable the "With Console" box when relevant
	switch (m_nProjectType)
	{
	case 0:
		m_WCONSLbutton.SetCheck(1);
		m_WCONSLbutton.EnableWindow(false);
		break;
	case 1: case 5: case 6:
		m_WCONSLbutton.SetCheck(0);
		m_WCONSLbutton.EnableWindow(false);
		break;
	default:
		m_WCONSLbutton.EnableWindow(true);
	}

	// Enable the "FLTK libraries" boxes when relevant
	switch (m_nProjectType)
	{
	case 4:
		m_FLTK_Forms_button.EnableWindow(true);
		m_FLTK_OpenGL_button.EnableWindow(true);
		m_FLTK_Images_button.EnableWindow(true);
	break;
	default:
		m_FLTK_Forms_button.EnableWindow(false);
		m_FLTK_OpenGL_button.EnableWindow(false);
		m_FLTK_Images_button.EnableWindow(false);
	}
	return TRUE;
}

void ProjectDlg::OnOK() 
{
	UpdateData();
	if (m_strTarget.IsEmpty())	{
		AfxMessageBox("Target name required", MB_ICONSTOP);
		m_target.SetFocus();
	}
	else if (m_strPath.IsEmpty())	{
		AfxMessageBox("Target path required", MB_ICONSTOP);
		m_projectpath.SetFocus();
	}
	else
		CDialog::OnOK();
}

void ProjectDlg::OnBrowseworking() 
{
	UpdateData();
	if (theApp.SelectFolder("Working Directory", &m_strWorking))
		UpdateData(0);	
}

void ProjectDlg::OnBrowseproject() 
{
	UpdateData();
	if (theApp.SelectFolder("Target Path", &m_strPath))
		UpdateData(0);	
}

void ProjectDlg::OnBnClickedLibrary()
{
	UpdateData();
	m_WCONSLbutton.SetCheck(0);
	m_WCONSLbutton.EnableWindow(false);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}
void ProjectDlg::OnBnClickedDll()
{
	UpdateData();
	m_WCONSLbutton.SetCheck(0);
	m_WCONSLbutton.EnableWindow(false);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}

void ProjectDlg::OnBnClickedGui()
{
	UpdateData();
	m_WCONSLbutton.SetCheck(0);
	m_WCONSLbutton.EnableWindow(false);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}

void ProjectDlg::OnBnClickedConsole()
{
	UpdateData();
	m_WCONSLbutton.SetCheck(1);
	m_WCONSLbutton.EnableWindow(false);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}

void ProjectDlg::OnBnClickedFltk()
{
	UpdateData();
	m_WCONSLbutton.EnableWindow(true);
	m_FLTK_Forms_button.EnableWindow(true);
	m_FLTK_OpenGL_button.EnableWindow(true);
	m_FLTK_Images_button.EnableWindow(true);
}

void ProjectDlg::OnBnClickedBgi()
{
	UpdateData();
	m_WCONSLbutton.EnableWindow(true);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}

void ProjectDlg::OnBnClickedKoolplot()
{
	UpdateData();
	m_WCONSLbutton.EnableWindow(true);
	m_FLTK_Forms_button.SetCheck(0);
	m_FLTK_Forms_button.EnableWindow(false);
	m_FLTK_OpenGL_button.SetCheck(0);
	m_FLTK_OpenGL_button.EnableWindow(false);
	m_FLTK_Images_button.SetCheck(0);
	m_FLTK_Images_button.EnableWindow(false);
}

void ProjectDlg::OnBnClickedWConsole()
{
	// TODO: Add your control notification handler code here
}

void ProjectDlg::OnBnClickedOk()
{
	// TODO: Add your control notification handler code here
	OnOK();
}
