// QuincyDoc.cpp : implementation of the CQuincyDoc class
//

#include "stdafx.h"
#include "Quincy.h"
#include "debugger.h"

#include "QuincyDoc.h"

#include "ProjectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuincyDoc

IMPLEMENT_DYNCREATE(CQuincyDoc, CDocument)

BEGIN_MESSAGE_MAP(CQuincyDoc, CDocument)
	//{{AFX_MSG_MAP(CQuincyDoc)
	ON_UPDATE_COMMAND_UI(ID_INSERT_FILE, OnUpdateTrue)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFalse)
	ON_COMMAND(ID_PROPERTIES, OnProperties)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnUpdateFalse)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

CQuincyDoc* CQuincyDoc::m_pOpenDocument = 0;

/////////////////////////////////////////////////////////////////////////////
// CQuincyDoc construction/destruction

CQuincyDoc::CQuincyDoc()
{
	// --- pointer to open document assures 
	//     that only one project is open at a time
	if (m_pOpenDocument != 0)
		m_pOpenDocument->OnCloseDocument();
	m_pOpenDocument = this;
	m_bModified = false;
	m_nProjectType = 0;
	m_bWithConsole = false;
	m_bFLTK_Forms  = false;
	m_bFLTK_OpenGL = false;
	m_bFLTK_Images = false;
	theApp.CloseErrorLog();
}

CQuincyDoc::~CQuincyDoc()
{
	m_pOpenDocument = 0;
}

BOOL CQuincyDoc::OnNewDocument()
{
	m_nProjectType = 0;
	m_bWithConsole = false;
	m_bFLTK_Forms  = false;
	m_bFLTK_OpenGL = false;
	m_bFLTK_Images = false;
	m_strTarget.Empty();
	m_strWorking.Empty();
	m_strPath.Empty();
	OnProperties();
	if (!m_strTarget.IsEmpty())	{
		CDocument::OnNewDocument();
		m_pOpenDocument = this;
		SetTitle(0);
		CString strTitle(m_strTarget);
		int ndx = strTitle.Find('.');
		if (ndx != -1)
			strTitle = strTitle.Left(ndx);
		_chdir(m_strPath);
		CString strFile = m_strTarget;
		// -- truncate ".prj" to prevent save from showing .prj.prj in save dialog
		strFile = strFile.Left(strFile.GetLength() - 4);
		SetTitle(strFile);
		SetModifiedFlag();
		return true;
	}
	return false;
}

void CQuincyDoc::OnProperties() 
{
	ProjectDlg dlg;
	dlg.m_nProjectType = m_nProjectType;
	dlg.m_bWithConsole = m_bWithConsole;
	dlg.m_bFLTK_Forms  = m_bFLTK_Forms;
	dlg.m_bFLTK_OpenGL = m_bFLTK_OpenGL;
	dlg.m_bFLTK_Images = m_bFLTK_Images;
	if (!m_strTarget.IsEmpty())	{
		dlg.m_strTarget = m_strTarget;
		dlg.m_strPath = m_strPath;
		int nx = dlg.m_strTarget.Find('.');
		if (nx != -1)
			dlg.m_strTarget = dlg.m_strTarget.Left(nx);
	}
	dlg.m_strWorking = m_strWorking;
	if (dlg.DoModal() == IDOK)	{
		if (m_nProjectType != dlg.m_nProjectType)	{
			SetModifiedFlag();
			m_nProjectType = dlg.m_nProjectType;
		}
		if (m_bWithConsole != dlg.m_bWithConsole)	{
			SetModifiedFlag();
			m_bWithConsole = dlg.m_bWithConsole;
		}
		if (m_bFLTK_Forms != dlg.m_bFLTK_Forms)	{
			SetModifiedFlag();
			m_bFLTK_Forms = dlg.m_bFLTK_Forms;
		}
		if (m_bFLTK_OpenGL != dlg.m_bFLTK_OpenGL)	{
			SetModifiedFlag();
			m_bFLTK_OpenGL = dlg.m_bFLTK_OpenGL;
		}
		if (m_bFLTK_Images != dlg.m_bFLTK_Images)	{
			SetModifiedFlag();
			m_bFLTK_Images = dlg.m_bFLTK_Images;
		}
		CString strTarget(dlg.m_strTarget);
		strTarget += (m_nProjectType == 6) ? ".dll" : 
					 (m_nProjectType == 5) ? ".a"  : ".exe";
		if (strTarget != m_strTarget)	{
			SetModifiedFlag();
			m_strTarget = strTarget;
			CString strTitle(GetTitle());
			int ndx = strTitle.Find(" [");
			if (ndx != -1)
				strTitle = strTitle.Left(ndx);
			SetTitle(strTitle);
		}
		if (dlg.m_strWorking != m_strWorking)	{
			SetModifiedFlag();
			m_strWorking = dlg.m_strWorking;
		}
		if (dlg.m_strPath != m_strPath)	{
			SetModifiedFlag();
			m_strPath = dlg.m_strPath;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyDoc serialization

void CQuincyDoc::Serialize(CArchive& ar)
{
	POSITION pos = GetFirstViewPosition();
	ASSERT(pos != 0);
	CListView* pView = (CListView*)GetNextView(pos);
	ASSERT(pView != 0);
	CListCtrl& rlist = pView->GetListCtrl();
	int itemcount;
	if (ar.IsStoring())	{
		ar << quincyVersion;	// Quincy signature
		ar << quincyVariant;		// Quincy variant
		ar << m_nProjectType;
		ar << m_strTarget;
		ar << m_bWithConsole;
		ar << m_bFLTK_Forms;
		ar << m_bFLTK_OpenGL;
		ar << m_bFLTK_Images;
		theApp.SerializeProjectOptions(ar, quincyVersion, quincyVariant);
		itemcount = rlist.GetItemCount();
		ar << itemcount;
		for (int item = 0; item < itemcount; item++)	{
			CString strDoc = rlist.GetItemText(item, 0);
			ar << strDoc;
		}
		ar << m_strWorking;
	}
	else	{
		rlist.DeleteAllItems();
		int nSig;
		int variant;
		ar >> nSig;
		if (nSig >= 2005)
			ar >> variant;

		CFile* pFile = ar.GetFile();
		ASSERT(pFile != 0);
		m_strPath = theApp.GetFilePath(pFile->GetFilePath());

		if (nSig == 9797 
			|| nSig == 9999 
			  || nSig == 2000 
			    || nSig == 2002
				  || nSig == 2005)	{
			// --- project file from Quincy 97, 99, 2000, 2002, 2005
			ar >> m_nProjectType;
			ar >> m_strTarget;
			ar >> m_bWithConsole;
			if (nSig > 2005 // From Q2005, version 1.2 (variant 1)
				  || (nSig == 2005 && variant > 0)) 
			{
				ar >> m_bFLTK_Forms;
				ar >> m_bFLTK_OpenGL;
				ar >> m_bFLTK_Images;
			}
			else
			{
				m_bFLTK_Forms = false;
				m_bFLTK_OpenGL = false;
				m_bFLTK_Images = false;
			}

			theApp.SerializeProjectOptions(ar, nSig, variant);
			ar >> itemcount;
		}
		else	{
			// --- project file from Quincy 96
			m_nProjectType = 0;

			m_strTarget = pFile->GetFileTitle();
			int nIndex = m_strTarget.ReverseFind('.');
			if (nIndex != -1)
				m_strTarget = m_strTarget.Left(nIndex);
			m_strTarget += ".exe";
			itemcount = nSig;
		}
		CString strItem;
		for (int item = 0; item < itemcount; item++)	{
			ar >> strItem;
			int nItems = rlist.GetItemCount();
			rlist.InsertItem(nItems, strItem);
		}
		if (nSig == 2000 
			  || nSig == 2002 
			    || nSig == 2005)
			ar >> m_strWorking;
	}
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyDoc diagnostics

#ifdef _DEBUG
void CQuincyDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CQuincyDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQuincyDoc commands

void CQuincyDoc::OnUpdateFalse(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(false);	
}

void CQuincyDoc::OnUpdateTrue(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(true);
}

void CQuincyDoc::SetTitle(LPCTSTR lpszTitle) 
{
	CString strTitle;
	if (lpszTitle == 0)
		strTitle = GetTitle();
	else
		strTitle = lpszTitle;
	if (!m_strTarget.IsEmpty())	{
		if (strTitle.Find('[') == -1)	{
			strTitle += " [";
			strTitle += m_strTarget + "]";
		}
	}
	CDocument::SetTitle(strTitle);
}


