// QuincyPrintDialog.cpp

#include "stdafx.h"
#include "quincy.h"
#include "QuincyPrintDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

LOGFONT CQuincyPrintDialog::logfont;

////////////////////////////
// CLineNumberButton class

IMPLEMENT_DYNAMIC(CLineNumberButton, CButton)

CLineNumberButton::CLineNumberButton()
{
}

BEGIN_MESSAGE_MAP(CLineNumberButton, CButton)
	//{{AFX_MSG_MAP(CLineNumberButton)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

int CLineNumberButton::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CButton::OnCreate(lpCreateStruct) == -1)
		return -1;
	font.CreateFontIndirect(&CQuincyPrintDialog::logfont);
	SetFont(&font);
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyPrintDialog

IMPLEMENT_DYNAMIC(CQuincyPrintDialog, CPrintDialog)

CQuincyPrintDialog::CQuincyPrintDialog(bool bSetup) :
	CPrintDialog(bSetup, PD_ALLPAGES | PD_USEDEVMODECOPIES | PD_NOSELECTION, 0)
{
	m_pd.nMinPage = 1;
	m_pd.nMaxPage = 0xffff;
	printlinenumbers = false;
}

BEGIN_MESSAGE_MAP(CQuincyPrintDialog, CPrintDialog)
	//{{AFX_MSG_MAP(CQuincyPrintDialog)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CQuincyPrintDialog::OnInitDialog() 
{
	CPrintDialog::OnInitDialog();
	GetFont()->GetLogFont(&logfont);

	CRect rc;
	GetClientRect(&rc);

	rc.top = rc.bottom - 30;
	rc.bottom = rc.top + 20;
	rc.left = 105;
	rc.right = rc.left + 110;

	bool b = lnobutton.Create(	"Print line numbers:", 
					BS_AUTOCHECKBOX | 
					BS_LEFTTEXT		| 
					WS_VISIBLE		| 
					WS_TABSTOP		|
					WS_CHILD,
					rc,
					this,
					IDC_LINENUMBERS);
	lnobutton.SetCheck(printlinenumbers);
	return true;
}

void CQuincyPrintDialog::OnOK()
{
	printlinenumbers = lnobutton.GetCheck() != 0;
	CPrintDialog::OnOK();
}
