// SampleCode.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "SampleCode.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSampleCode

CSampleCode::CSampleCode()
{
	m_tabstops = 4;
	m_syntaxcolor = true;
	m_fontheight = 13;
	m_fontwidth = 8;
	m_fontweight = FW_NORMAL;
}

CSampleCode::~CSampleCode()
{
}

BEGIN_MESSAGE_MAP(CSampleCode, CEdit)
	//{{AFX_MSG_MAP(CSampleCode)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleCode message handlers

const char* code[] = {
	"\\c// --- sample.cpp",
	"\\k#include \\n<iostream>",
	"\\kint\\n main()",
	"{",
	"\t\\c// Say hello",
	"\t\\nstd::cout << \\s\"\\\\nHello\"\\n;",
	"\t\\kreturn\\n 0;",
	"}"
};

bool CSampleCode::testfont(int ht, int wd)
{
	CFont* font = new CFont;
	theApp.EditorScreenFont(font, ht, wd, m_fontweight);
	CClientDC cdc(this);
	CFont* pOldFont = cdc.SelectObject(font);
	TEXTMETRIC tm;
	cdc.GetTextMetrics(&tm);
	cdc.SelectObject(pOldFont);
	delete font;
	return ht != tm.tmHeight || wd != tm.tmMaxCharWidth;
}

static const int maxheight = 40;
static const int minheight = 13;
static const int fontincr = 1;

void CSampleCode::AdjustFont(int adj)
{
	if (m_fontheight < maxheight-adj && m_fontheight > minheight-adj)	{
		do	{
			m_fontheight += adj;
			m_fontwidth = m_fontheight * theApp.DefaultFontWidth() / theApp.DefaultFontHeight();
			if (m_fontheight >= maxheight || m_fontheight <= minheight)
				break;
		} while (testfont(m_fontheight, m_fontwidth));
	}
	Invalidate();
}

void CSampleCode::IncreaseFont()
{
	AdjustFont(fontincr);
}

void CSampleCode::DecreaseFont()
{
	AdjustFont(-fontincr);
}

void CSampleCode::DefaultFont()
{
	m_fontheight = theApp.DefaultFontHeight();
	m_fontwidth = theApp.DefaultFontWidth();
	m_fontweight = FW_NORMAL;
	Invalidate();
}

void CSampleCode::OnPaint() 
{
	CPaintDC dc(this); // device context for painting

	CFont* font = new CFont;
	theApp.EditorScreenFont(font, m_fontheight, m_fontwidth, m_fontweight);
	CFont* pOldFont = dc.SelectObject(font);
	COLORREF backgroundcolor = m_syntaxcolor ? m_backgroundcolor : RGB(255,255,255);
	COLORREF normalcolor = m_syntaxcolor ? m_normalcolor : RGB(0,0,0);
	dc.SetBkColor(backgroundcolor);
	dc.SetTextColor(normalcolor);
	CRect rc;
	GetClientRect(&rc);
	CBrush br(backgroundcolor);
	dc.FillRect(&rc, &br);

	for (int i = 0; i < sizeof code / sizeof(const char*); i++)	{
		int x = 0;
		const char* cp;
		for (cp = code[i]; *cp; cp++)	{
			char ch[] = " ";
			if (*cp == '\\')	{
				cp++;
				if (m_syntaxcolor)	{
					COLORREF clr;
					switch (*cp)	{
						case 'n':
							clr = m_normalcolor;
							break;
						case 's':
							clr = m_stringcolor;
							break;
						case 'k':
							clr = m_keywordcolor;
							break;
						case 'c':
							clr = m_commentcolor;
							break;
						default:
							break;
					}
					dc.SetTextColor(clr);
				}
				if (*cp != '\\')
					continue;
			}
			if (*cp == '\t')
				for (; x < m_tabstops; x++)
					dc.ExtTextOut(x * m_fontwidth, i * m_fontheight, ETO_CLIPPED, &rc, ch, 1, 0);
			else	{
				*ch = *cp;
				int col = (x++) * m_fontwidth;
				if (col + m_fontwidth < rc.right)
					dc.ExtTextOut(col, i * m_fontheight, ETO_CLIPPED, &rc, ch, 1, 0);
			}
		}
	}
	dc.SelectObject(pOldFont);
	delete font;
}
