// TutDlg.cpp : implementation file
//


#include "stdafx.h"

#ifdef TYCPP

#include "quincy.h"
#include "TutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTutDlg dialog


CTutDlg::CTutDlg(const CString& strTocName)
	: m_strTocName(strTocName), CDialog(IDD_TUTORIAL, 0)
{
	//{{AFX_DATA_INIT(CTutDlg)
	//}}AFX_DATA_INIT

	for (int i = 0; i < maxentries; i++)	{
		m_TreeEntry[i].m_nLevel = 0;
		m_TreeEntry[i].m_hItem = 0;
	}
	m_hRootItem = 0;
	m_nEntries = 0;
}


void CTutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTutDlg)
	DDX_Control(pDX, IDC_EXERCISETREE, m_ExerciseTree);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTutDlg, CDialog)
	//{{AFX_MSG_MAP(CTutDlg)
	ON_WM_DESTROY()
	ON_WM_CREATE()
	ON_NOTIFY(NM_DBLCLK, IDC_EXERCISETREE, OnDblclkExercisetree)
	ON_NOTIFY(NM_CLICK, IDC_EXERCISETREE, OnClickExercisetree)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CTutDlg::OpenExercise(const CString& strTutorial)
{
	// --- extract the chapter and exercise number from the .tut filename
	char cEx[4];
	for (int i = 0; i < 3; i++)
		cEx[i] = strTutorial[i + strTutorial.GetLength() - 7];
	cEx[3] = '\0';
	UINT nExercise = atoi(cEx);
	for (i = 0; i < 2; i++)
		cEx[i] = strTutorial[i + strTutorial.GetLength() - 9];
	cEx[2] = '\0';
	UINT nChapter = atoi(cEx);

	// ---- navigate to and expand the chapter item
	for (i = 0; (UINT)i < m_nEntries; i++)	{
		if (m_TreeEntry[i].m_nLevel == 2)	{
			char buff[26];
			TV_ITEM item = {
				TVIF_HANDLE | TVIF_TEXT,
				m_TreeEntry[i].m_hItem,
				0, 0,
				buff, 25
			};
			m_ExerciseTree.GetItem(&item);
			if (atoi(buff + 8) == nChapter)	{
				m_ExerciseTree.Expand(m_TreeEntry[i].m_hItem, TVE_EXPAND);
				break;
			}
		}
	}

	// ---- navigate to and select the exercise item
	while ((UINT) ++i < m_nEntries && m_TreeEntry[i].m_nLevel == 3)	{
		char buff[26];
		TV_ITEM item = {
			TVIF_HANDLE | TVIF_TEXT,
			m_TreeEntry[i].m_hItem,
			0, 0,
			buff, 25
		};
		m_ExerciseTree.GetItem(&item);
		char* cp = strchr(buff, '.');
		if (cp != 0 && atoi(cp+1) == nExercise)	{
			m_ExerciseTree.Select(m_TreeEntry[i].m_hItem, TVGN_CARET);
			break;
		}
	}
	m_ExerciseTree.SetFocus();
}

/////////////////////////////////////////////////////////////////////////////
// CTutDlg message handlers
void CTutDlg::OnDestroy()
{
	theApp.SaveDialogWindowPosition("TutorialDialog", this);
	CDialog::OnDestroy();
}

int CTutDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	theApp.RestoreDialogWindowPosition("TutorialDialog", this);
	theApp.SetTutorialDisplay(true);
	return 0;
}

BOOL CTutDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

 /*
	HICON hIcon;

	m_imgList.Create (
	   16,		// BITMAP_WIDTH,
	   16,		// BITMAP_HEIGHT,
	   FALSE,   // list does not include masks
	   6,		// NUM_BITMAPS,
	   0);      // list won't grow
		
	// Load the icons and add them to the image lists.

	static int nIcons[] = {
		IDI_BOOKREDCL, IDI_BOOKREDOP, 
		IDI_BOOKOLICL, IDI_BOOKOLIOP, 
		IDI_BOOKSHEET, IDI_BOOKSHEET,
	};

	for (int i = 0; i < 6; i++)	{
		hIcon = ::LoadIcon(AfxGetResourceHandle(), MAKEINTRESOURCE(nIcons[i]));
		m_nImages[i] = m_imgList.Add(hIcon);
	}

	// Associate the image lists with the list view control.
	m_ExerciseTree.SetImageList(&m_imgList, LVSIL_NORMAL);
 */
	HTREEITEM hdrs[5] = {TVI_ROOT};

	// ----- open the toc file
	CStdioFile tocfile;
	if (tocfile.Open(m_strTocName, CFile::modeRead | CFile::typeText) == 0)	{
		CString strMsg = m_strTocName + " does not exist";
		AfxMessageBox(strMsg, MB_OK | MB_ICONEXCLAMATION);
		return false;
	}

	// ----- build the table of contents tree control
	m_nEntries = 0;
	CString strText;
	while (tocfile.ReadString(strText) != false)	{
		// bypass comments
		if (strText.Left(1) == ";")
			continue;
		int level = 1;
		int nSz = strText.GetLength();
		while (strText.Left(2) == "  ")	{
			level++;
			nSz -= 2;
			strText = strText.Right(nSz);
		}
		ASSERT(level < 4);
		CString strPrefix;
		switch (level)	{
			case 3:
				strPrefix = "Program " + m_strChapterNo + ".";
				break;
			case 2:
			{
				strPrefix = "Chapter ";
				int nIndex = strText.Find(':');
				ASSERT(nIndex > 0);
				m_strChapterNo = strText.Left(nIndex);
				break;
			}
			default:
				break;
		}
		
		hdrs[level] = m_ExerciseTree.InsertItem(strPrefix + strText, hdrs[level-1]);

		ASSERT(m_nEntries < maxentries);
		m_TreeEntry[m_nEntries].m_hItem = hdrs[level];
		m_TreeEntry[m_nEntries++].m_nLevel = level;

		m_ExerciseTree.SetItemImage(hdrs[level], m_nImages[(level-1) * 2], m_nImages[(level-1) * 2 + 1] ); 
	}
	tocfile.Close();
	m_hRootItem = hdrs[1];
	m_ExerciseTree.Expand(m_hRootItem, TVE_EXPAND);

	return true;
}

void CTutDlg::OnOK() 
{
	HTREEITEM hItem = m_ExerciseTree.GetSelectedItem();
	theApp.OpenTutorial(m_ExerciseTree.GetItemText(hItem));
//	CDialog::OnOK();
}


void CTutDlg::OnDblclkExercisetree(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
	OnOK();
}

void CTutDlg::OnClickExercisetree(NMHDR* pNMHDR, LRESULT* pResult) 
{
}

void CTutDlg::OnCancel() 
{
	theApp.SetTutorialDisplay(false);
	CDialog::OnCancel();
}

#endif // TYCPP
