// WatchDialog.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "WatchDialog.h"
#include "AddWatch.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWatchDialog dialog


CWatchDialog::CWatchDialog(CWnd* pParent)
	: CDialog(CWatchDialog::IDD, pParent)
{
	Watches = 0;
	m_pdlgAddWatch = new CAddWatch;

	//{{AFX_DATA_INIT(CWatchDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CWatchDialog::~CWatchDialog()
{
	delete 	m_pdlgAddWatch;
	delete [] Watches;
}

void CWatchDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWatchDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWatchDialog, CDialog)
	//{{AFX_MSG_MAP(CWatchDialog)
	ON_BN_CLICKED(IDC_ADDWATCH, OnAddwatch)
	ON_BN_CLICKED(IDC_DELETEWATCH, OnDeletewatch)
	ON_WM_DESTROY()
	ON_WM_CREATE()
	ON_BN_CLICKED(IDC_DELETEWATCHES, OnDeletewatches)
	ON_COMMAND(ID_HELP, OnHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWatchDialog message handlers

int CWatchDialog::GetWatchCount()
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	return pList->GetCount();
}

void CWatchDialog::GetWatchValue(int nSel, CString& strValue)
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	pList->GetText(nSel, strValue);
	int nIndex = strValue.Find(':');
	if (nIndex != -1)
		strValue = strValue.Left(nIndex);
}

void CWatchDialog::OnAddwatch() 
{
	ASSERT(m_pdlgAddWatch != 0);
	if (m_pdlgAddWatch->DoModal() == IDOK)
		AddWatch(m_pdlgAddWatch->m_strWatchVariable);
}

void CWatchDialog::AddSelectedWatch(const std::string& watch)
{
	m_pdlgAddWatch->m_strWatchVariable = watch.c_str();
	OnAddwatch();
}

void CWatchDialog::AddWatch(const CString& strWatch)
{
	if (!strWatch.IsEmpty())	{
		CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
		ASSERT(pList != 0);
		int rtn = pList->FindString(-1, strWatch + " := ");
		if (rtn == 	LB_ERR)	{
			pList->AddString(strWatch + " := ");
			theApp.PostWatchList();
		}
	}
}

CListBox* CWatchDialog::GetWatchListbox()
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	return pList;
}

CString* CWatchDialog::GetWatchNames()
{
	int ct = GetWatchCount();

	delete [] Watches;
	Watches = new CString[ct];

	for (int nSel = 0; nSel < ct; nSel++)	{
		CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
		ASSERT(pList != 0);
		CString strVarName;
		pList->GetText(nSel, strVarName);
		int offset = strVarName.Find(" := ");
		if (offset != -1)
			strVarName = strVarName.Left(offset+4);
		Watches[nSel] = strVarName;
	}
	return Watches;
}

void CWatchDialog::OnDeletewatch() 
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	int nSel = pList->GetCurSel();
	if (nSel != LB_ERR)	{
		pList->DeleteString(nSel);
		int nCt = pList->GetCount();
		if (nSel < nCt)
			pList->SetCurSel(nSel);
		else if (nSel > 0)
			pList->SetCurSel(nSel-1);
	}
}

void CWatchDialog::OnDeletewatches() 
{
	ClearWatches();
}

void CWatchDialog::DisplayWatch(const CString& strVarName, const CString& strVarValue)
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	CString strWatch = strVarName + ": " + strVarValue;

	int nSel = pList->FindString(-1, strVarName);
	if (nSel != LB_ERR)	{
		pList->DeleteString(nSel);
		pList->InsertString(nSel, strWatch);
	}
}

void CWatchDialog::OnDestroy()
{
	theApp.SaveDialogWindowPosition("WatchWindow", this);
	CDialog::OnDestroy();
}

int CWatchDialog::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	theApp.RestoreDialogWindowPosition("WatchWindow", this);
	return 0;
}

void CWatchDialog::ClearWatches()
{
	CListBox* pList = static_cast<CListBox*>(GetDlgItem(IDC_WATCHLIST));
	ASSERT(pList != 0);
	pList->ResetContent();
}


void CWatchDialog::OnHelp() 
{
	theApp.HtmlHelp("watch", 0);
}

