// Beautifer.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "Beautifier.h"
#include "EditorDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CBeautifier* CBeautifier::pBeautifier;

/////////////////////////////////////////////////////////////////////////////
// CBeautifier dialog


CBeautifier::CBeautifier(CWnd* pParent /*=NULL*/)
	: CDialog(CBeautifier::IDD, pParent)
{
	//{{AFX_DATA_INIT(CBeautifier)
	m_style = -1;
	m_Cmdline = _T("");
	//}}AFX_DATA_INIT
	font = new CFont;
	theApp.EditorScreenFont(font, theApp.DefaultFontHeight(), theApp.DefaultFontWidth(), FW_NORMAL);
	m_pConsoleApp = 0;
}

CBeautifier::~CBeautifier()
{
	delete font;
}

void CBeautifier::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CBeautifier)
	DDX_Control(pDX, IDC_TESTSTYLE, m_TestStyle);
	DDX_Control(pDX, IDC_ASTYLECMDLINE, m_CmdLineEdit);
	DDX_Control(pDX, IDC_SAMPLECODE, m_samplecode);
	DDX_Radio(pDX, IDC_STYLE1, m_style);
	DDX_Text(pDX, IDC_ASTYLECMDLINE, m_Cmdline);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBeautifier, CDialog)
	//{{AFX_MSG_MAP(CBeautifier)
	ON_BN_CLICKED(IDC_STYLE1, OnStyle)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_BN_CLICKED(IDC_STYLE2, OnStyle)
	ON_BN_CLICKED(IDC_STYLE3, OnStyle)
	ON_BN_CLICKED(IDC_STYLE4, OnStyle)
	ON_BN_CLICKED(IDC_TESTSTYLE, OnStyle)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CBeautifier::OnInitDialog() 
{
	CDialog::OnInitDialog();
	m_samplecode.SetFont(font, FALSE);
	UpdateData(false);
	OnStyle();
	return TRUE;
}

static char* style[] = {
	"namespace applname {",
	"int Foo()",
	"{",
	"\tif (isBar) {",
	"\t\tbar();",
	"\t\treturn 1;",
	"\t} else",
	"\t\treturn 0;",
	"}",
	"}",
	0
};

/////////////////////////////////////////////////////////////////////////////
// CBeautifier message handlers

void CBeautifier::OnStyle() 
{
	UpdateData();

	m_CmdLineEdit.SetReadOnly(m_style != 3);
	m_TestStyle.EnableWindow(m_style == 3);

	pBeautifier = this;
	beautifiedtext.clear();
	CString strExe = theApp.Enquote(theApp.QuincyBinPath() + "\\astyle.exe ");

	static char* st[] = {
		"--mode=c --indent-switches --brackets=linux",
		"--style=ansi",
		"--style=gnu --indent-blocks",
	};

	static char* in[] = {
		"tab",
		"spaces"
	};

	CString strArgs;

	int tabs = theApp.Tabstops();

	if (m_style == 3)
		strArgs = m_Cmdline;
	else	{
		strArgs.Format("%s --indent=%s=%d", 
			st[m_style], 
			in[theApp.TabOption()],
			tabs);
	}
	m_Cmdline = strArgs;
	UpdateData(false);

	delete m_pConsoleApp;
	m_pConsoleApp = new ConsoleApp(strExe, &Notify, &Collect);
	try	{
		m_pConsoleApp->Run(strArgs);

		int lines = sizeof style / sizeof(char*) - 1;
		if (lines != 0) {
			for (int i = 0; i < lines; i++) {
				std::string str = style[i];
				m_pConsoleApp->WriteConsole(str.c_str());
				TRACE("\nOUT: %s", str.c_str());
			}
		}
		char ctrlz[2] = {26,0};
		m_pConsoleApp->WriteConsole(ctrlz);
	}
	catch(...)	{
		AfxMessageBox("\nCannot execute Astyle", MB_ICONSTOP);
	}
}

// --- called from the console application thread while beautifying is going on
void CBeautifier::Collect(DWORD bufct)
{
	ASSERT(pBeautifier != 0);
	pBeautifier->CollectSourceLines(bufct);
}

void CBeautifier::CollectSourceLines(DWORD bufct)
{
	char *line = new char[bufct+1];
	ASSERT(m_pConsoleApp);
	if (m_pConsoleApp->ReadConsole(line, bufct) != 0)	{
		TRACE("\nIN:  %s", line);
		std::string str(line);
		beautifiedtext.push_back(str);
	}
	delete [] line;
}

void CBeautifier::Notify()
{
	ASSERT(pBeautifier != 0);
	pBeautifier->NotifyTermination();
}

void CBeautifier::NotifyTermination()
{
	TRACE("\n---done---\n");
	beautifiedtext.push_back(std::string());

	int tabs = theApp.Tabstops();
	char text[800];
	int n = 0;
	std::vector<std::string>::iterator iter;
	for (iter = beautifiedtext.begin(); iter != beautifiedtext.end(); iter++)	{
		int x = 0;
		const char* cp;
		for (cp = (*iter).c_str(); *cp; cp++)	{
			if (*cp == '\t')	{
				do
					text[n++] = ' ';
				while (++x % tabs);
			}
			else	{
				text[n++] = *cp;
				x++;
			}
		}
		text[n++] = '\n';
	}
	text[n] = '\0';
	m_samplecode.SetWindowText(text);
	beautifiedtext.clear();

	delete m_pConsoleApp;
	m_pConsoleApp = 0;
	pBeautifier = 0;
}

void CBeautifier::OnHelp() 
{
	ShellExecute(0, "open", (theApp.QuincyInstallPath() + 
		"\\html\\astyle\\astyle.html").GetBuffer(0), 0, 0, SW_SHOW);
}


