// ----- consoleapp.h

#ifndef CONSOLEAPP_H
#define CONSOLEAPP_H

#include "stdafx.h"
#include <string>
#include <queue>

class ConsoleApp	{

	HANDLE hOutputReadTmp;
	HANDLE hInputWriteTmp;
	HANDLE hOutputRead;
	HANDLE hOutputWrite;
	HANDLE hInputRead;
	HANDLE hInputWrite;
	HANDLE hErrorWrite;


	PROCESS_INFORMATION pinfo;
	DWORD exitcode;
	std::string Exename;
	std::string Args;
	bool running;
	bool successfulrun;
	DWORD bufferct;
	std::queue<char> buffer;
	void (*InputReady)(DWORD);
	void (*Termfunc)();
	void fillbuffer();
	void flushbuffer();
	void closehandle(HANDLE& handle);
	void shutdown();
	static ConsoleApp* consoleapp;
	static UINT DoRun(void*);
	void runapplication();
public:
	ConsoleApp(const char* exename, void (*termfunc)() = 0, void (*cbfunc)(DWORD) = 0);
	~ConsoleApp();
	void Run(const char* params = 0);
	void WriteConsole(const char* cmd);
	int ReadConsole(char* line, unsigned int nchars);
	void Stop();
	bool IsRunning() const { return running; }
	bool SuccessfulRun() const { return successfulrun; }
	DWORD Exitcode() const { return exitcode; }
};

#endif

