// ---- grep.h
#ifndef GREP_H
#define GREP_H

#include "GrepInput.h"
#include "GrepResult.h"
#include "ConsoleApp.h"

class Grep	{
	static Grep* pGrep;
	const int grepcount;
	enum GrepStatus { idle, starting, running, terminating, done };
	int grepstepper;
	static char* extensions[];
	GrepStatus status;
	bool m_bGrepInputCreated;	// true if grep input dialog has been created
	bool m_bGrepResultCreated;	// true if grep result dialog has been created
	UINT m_nGrepCount;			// # entries in grep log
	CString m_strParams;		// grep command line parameters
	std::vector<ErrorMessage> GrepLog;
	GrepResult* m_pdlgGrepResult;
	GrepInput* m_pdlgGrepInput;
	ConsoleApp* m_pConsoleApp;
	void RunGrep(const CString& params);
	void CollectMessages(DWORD bufct);
	static void Collect(DWORD bufct);
	static void Notify();
	void NotifyTermination();
public:
	Grep();
	~Grep();
	void OnGrep();
	void Stop();
	void SelectGrepLine(int nsel);
	bool IsRunning()
		{ return status == starting || status == running; }
};


#endif // GREP_H