// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "Quincy.h"
#include "debugger.h"

#include "MainFrm.h"
#include "QuincyView.h"
#include "TextView.h"
#include "childfrm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
	ON_WM_CLOSE()
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_COMMAND(ID_WINDOW_CLOSE_ALL, OnWindowCloseAll)
	ON_COMMAND(ID_FILE_SAVE_ALL, OnFileSaveAll)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_ALL, OnUpdateFileSaveAll)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
	// Global help commands
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_EXT,
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
};


/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

/* Tutorials are replaced by commented examples
void CMainFrame::HideTYCPPCommand()
{
#ifdef _DEBUG
	m_wndToolBar.GetToolBarCtrl().HideButton(ID_WRITETUTORIAL);
#endif
	m_wndToolBar.GetToolBarCtrl().HideButton(ID_TYCPP);
	CMenu* menu = GetMenu();
	ASSERT(menu != 0);
	menu->RemoveMenu(ID_TYCPP, MF_BYCOMMAND);
} */

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	LoadWindowPlacement();
	if (!m_wndToolBar.CreateEx(this) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

/* No tutorial
#ifndef _DEBUG
	m_wndToolBar.GetToolBarCtrl().HideButton(ID_WRITETUTORIAL);
#endif

#ifndef TYCPP
  #ifdef _DEBUG
	m_wndToolBar.GetToolBarCtrl().HideButton(ID_WRITETUTORIAL);
  #endif
	HideTYCPPCommand();
#endif
*/
	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}


	m_wndStatusBar.SetPaneInfo(1, ID_INDICATOR_EXT, 0, 120);
	m_wndStatusBar.SetPaneText(1, "");
  
	// TODO: Remove this if you don't want tool tips or a resizeable toolbar
	m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
		CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);

/*	
	char* btstrs = {
		"New\0Open\0Save\0Save all\0"
		"Print\0Print Preview\0"
		"Cut\0Copy\0Paste\0Find\0"
		"Undo\0Redo\0"
		"Brace match\0"
		"Build\0Build All\0"
		"Stop\0Run\0Step\0Step Over\0Step to\0Step out\0"
		"Breakpoint\0Clear breakpoints\0"
		"Watch\0Examine\0"
		"Example programs\0"
		"Tutorial\0\0";
*/

/*
	char* btstrs[] = {
		"New", "Open", "Save", "Save all", 0,
		"Print", "Print Preview", 0,
		"Cut", "Copy", "Paste", "Find", 0,
		"Undo",  "Redo",
		"Brace match",
		"Build", "Build All",
		"Stop", "Run", "Step", "Step Over", "Step to", "Step out",
		"Breakpoint", "Clear breakpoints",
		"Watch", "Examine",
		"Example programs",
		"Tutorial"
	};

	const int nbuttons = sizeof btstrs / sizeof(char*);

//	int rtn = m_wndToolBar.GetToolBarCtrl().AddStrings(btstrs);

	for (int i = 0; i < nbuttons; i++)	{
		m_wndToolBar.SetButtonText(i, btstrs[i]);
		UINT style = m_wndToolBar.GetButtonStyle(i);
		m_wndToolBar.SetButtonStyle(i, style | TBSTYLE_AUTOSIZE);
	}

*/
	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

	LoadBarState("Settings");

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	// Use the specific class name we established earlier
	cs.lpszClass = _T("QuincyAppClass");
	return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

void CMainFrame::LoadWindowPlacement()
{
	CString strBuffer = theApp.GetProfileString("Settings", "WindowPos");
	if (!strBuffer.IsEmpty())	{
		WINDOWPLACEMENT wp;
		int cRead = _stscanf(strBuffer, "%i:%i:%i:%i:%i:%i:%i:%i:%i:%i",
				&wp.flags, &wp.showCmd,
				&wp.ptMinPosition.x, &wp.ptMinPosition.y,
				&wp.ptMaxPosition.x, &wp.ptMaxPosition.y,
				&wp.rcNormalPosition.left, &wp.rcNormalPosition.top,
				&wp.rcNormalPosition.right, &wp.rcNormalPosition.bottom);

		if (cRead == 10)	{
			wp.showCmd = theApp.m_nCmdShow;
			if (wp.flags & WPF_RESTORETOMAXIMIZED)
				theApp.m_nCmdShow = SW_SHOWMAXIMIZED;
			SetWindowPlacement(&wp);
		}
	}
}

VOID CMainFrame::SaveWindowPlacement()
{
	WINDOWPLACEMENT wp;
	if (GetWindowPlacement(&wp))	{
		if (IsZoomed())
			wp.flags = WPF_RESTORETOMAXIMIZED;
		CString strBuffer;
		strBuffer.Format("%i:%i:%i:%i:%i:%i:%i:%i:%i:%i",
			wp.flags, wp.showCmd,
			wp.ptMinPosition.x, wp.ptMinPosition.y,
			wp.ptMaxPosition.x, wp.ptMaxPosition.y,
			wp.rcNormalPosition.left, wp.rcNormalPosition.top,
			wp.rcNormalPosition.right, wp.rcNormalPosition.bottom);
		theApp.WriteProfileString("Settings", "WindowPos", strBuffer);
	}
}


void CMainFrame::SetRowColumn(int row, int column)
{
	if (::IsWindow(m_wndStatusBar.m_hWnd))	{
		CString str;
		if (row != 0)
			str.Format("Ln %d, Col %d", row, column);
		m_wndStatusBar.SetPaneText(1, str.GetBuffer(0));
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

void CMainFrame::OnClose()
{
	if (theApp.StopDebugging())	{
		theApp.SaveOpenDocuments();
		SaveBarState("Settings");
		SaveWindowPlacement();
		::WinHelp(m_hWnd, theApp.m_pszHelpFilePath, HELP_QUIT, 0);
		CMDIFrameWnd::OnClose ();
	}
}

void CMainFrame::OnWindowCloseAll() 
{
	theApp.SaveAllModified();
	theApp.CloseAllDocuments(false);
}

void CMainFrame::OnFileSaveAll() 
{
	theApp.SaveAllDocuments();
}

void CMainFrame::OnUpdateFileSaveAll(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);
}

BOOL CMainFrame::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class

	return CMDIFrameWnd::OnCommand(wParam, lParam);
}


void CMainFrame::OnDestroy() 
{
	CMDIFrameWnd::OnDestroy();
	
	// TODO: Add your message handler code here
	
}

