// Quincy.h : main header file for the QUINCY application
//

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#ifndef QUINCY_H
#define QUINCY_H

#include <set>
#include "resource.h"       // main symbols
#include "consoleapp.h"
#include "gdbconsole.h"

/////////////////////////////////////////////////////////////////////////////
// CQuincyApp:
// See Quincy.cpp for the implementation of this class
//

class CQuincyDoc;
class CQuincyView;
class CErrorLogDialog;
class CTextDocument;
class CTextView;
class CWatchDialog;
class CExamineDialog;
class Parser;
class Debugger;
// class CTutDlg;

struct ErrorMessage {						// error/warning log
	UINT m_nLineNumber;
	CString m_strErrorMsg;
	CString m_strFileSpec;
};

struct Breakpoint	{
	CString m_strFile;
	int m_nLineNo;
	Breakpoint(CString fname = CString(), int lno = 0) : m_strFile(fname), m_nLineNo(lno)	{ }
	bool operator<(const Breakpoint& fr) const
		{ return (m_strFile == fr.m_strFile) ? (m_nLineNo < fr.m_nLineNo) : (m_strFile < fr.m_strFile); }
	bool operator==(const Breakpoint& fr) const
		{ return (m_strFile == fr.m_strFile) ? (m_nLineNo == fr.m_nLineNo) : (m_strFile < fr.m_strFile); }
	Breakpoint& operator=(const Breakpoint& fr)
	{
		if (this != &fr)	{
			m_strFile = fr.m_strFile;
			m_nLineNo = fr.m_nLineNo;
		}
		return *this;
	}
};


//#define CYGWIN_GDB

class CEditorView;

class CQuincyApp : public CWinApp
{
	bool m_bWatchCreated;		// true if watch window has been created
	bool m_bGdbConsoleCreated;	// true if gdb console window has been created
	bool m_bCpp;				// true if compiling .cpp
	bool m_bDoLink;				// true if linking
	bool m_bBypassChangeTest;	// true when user says run in spite of changes

	bool appendnexttext;		// true to append text to previous gdb console prompt
	bool stepping;

	bool m_bBrowser;			// true if a browser is installed

/* No tutorial since Quincy 2005 v1.1
#ifdef TYCPP
	bool m_bReadTutorial;		// true when a tutorial is to be loaded
	bool m_bTutCreated;			// true if tutorial dialog has been created
	bool m_bIsTutorial;			// true if tutorial table of contents is present
	bool m_bTutorialDisplayed;  // true when tutorial is displayed
#endif
*/
	bool m_bGrepIsInstalled;	// true when grep tool is installed
	bool m_bAStyleIsInstalled;  // true when beautifier tool is installed
	bool m_bWEditResIsInstalled;// true when resource editor is installed
	bool m_bCompilerIsInstalled;// true when the gnu compiler is installed
	bool m_bFluidIsInstalled;   // true when the Fluid GUI builder is installed

	class Compiler *m_pCompiler;
	class Grep* m_pGrep;
	class Executor* m_pExecutor;

	CStringArray m_Defines;		// #define expressions
	CStringArray m_Includes;	// #include paths
	CStringArray m_Libs;		// library paths

	CString m_strVersion;			// gnu-mingw32 compiler version
	CString m_strQuincyInstallPath;	// where quincy is installed
	CString m_strQuincyBinPath;		// quincy.exe path
	CString m_strLCCPath;			// resource compiler and editor path
	CString m_strRIncludePath;		// resource compiler include path
	CString m_strIncludePath;		// compiler include path
	CString m_strXIncludePath;		// Xtra libraries include path

private:
	CString m_strLibPath;		// path to standard C/C++ libraries
	CString m_strXLibPath;		// path to embedded Xtra libraries
	CString m_strToolsPath;		// path to assembler, librarian, linker
	CString m_strStartupCode;	// path to compiler's startup code (crt0.o)

	CString m_strCmdLineOptions;// additional user-specified gcc command-line options
	CString m_strLinkerOptions;// additional user-specified linker command-line options
/* No tutorial since Quincy 2005 v1.1
#ifdef TYCPP
	CString m_strTutorialPath;	// path to tutorials
	CString m_strTutorial;		// name of current tutorial file
#endif
*/
	CString m_strTempPath;		// path pointed to by TEMP environment variable
//	CString m_strWorkingPath;	// working path for programs and the compiler

	CView* m_pView;				// -> view of document being compiled

	CEditorView* m_pEditorView;	// -> current active editor view

	DWORD m_nExitCode;			// exit code from compiler programs

	// ----- options
	BOOL m_bWithConsole;			// option to have graphics with a console as well
	BOOL m_bFLTK_Forms;				// option to use FLTK Forms library
	BOOL m_bFLTK_OpenGL;			// option to use FLTK OpenGL library
	BOOL m_bFLTK_Images;			// option to use FLTK Images library
	BOOL m_bDebugging;				// option for adding debug information
	BOOL m_bExceptions;				// option for enabling C++ exception handling 
	BOOL m_bRTTI;					// option for enabling C++ runtime type information
	BOOL m_bStrict;					// option for enabling C/C++ strict ANSI/ISO compliance
	BOOL m_bC99;					// option for enforcing C99 standards in C programs
	int m_bWarnType;				// option for enabling default/all/no compiler warnings
	int m_style;					// beautify indenting style
	CString m_command;				// beautifier (AStyle) command line
	int m_maxundos;					// maximum number of editor undos
	bool m_bPrintLineNos;			// true for printing line numbers
	int m_CommandLinePromptOption;	// option for command line prompt
	int m_nOptimize;				// compile optimize option
	int m_tabstops;					// editor tabstops
	int m_taboption;				// 0 = use tab characters, 1 = use spaces
	bool m_bAutoindent;				// true for autoindent feature in editor
	bool m_bSyntaxColors;			// true for syntax colors
	COLORREF m_backgroundcolor;		// syntax color values
	COLORREF m_normalcolor;
	COLORREF m_keywordcolor;
	COLORREF m_commentcolor;
	COLORREF m_stringcolor;
	int m_fontheight;
	int m_fontwidth;
	int m_fontweight;
//	CString m_fontface;
	CString m_strCommandLine;		// default command line
	CString m_strRuntimeDirectory;	// runtime directory
	CString m_strCompiler;			// where the compiler is installed
	CString m_strDebugger;			// where the debugger is installed

	int m_defaultfontheight;
	int m_defaultfontwidth;
	
	GdbConsole* m_pdlgGdbConsole;
	CWatchDialog* m_pdlgWatch;
	CExamineDialog* m_pdlgExamine;
	// ------ source level debugger
	Debugger* m_pDebugger;

	// --- programmed breakpoints 
	std::set<Breakpoint> breakpoints;
	Breakpoint steptobreakpoint;

	CRect m_ConsoleRect;			// screen position of console window

/* No tutorial since Quincy 2005 v1.1
#ifdef TYCPP
	CTutDlg* m_pCTutDlg;
#endif
*/
	OSVERSIONINFO osversion;

	// ------------------ methods

	void SetCompilerPaths();
//	void TestDebuggerPath();
	void SetBrowserPath();

	void LoadArray(CStringArray& array, const CString& rstr);
	void GetArray(CString& str, const CStringArray& array) const;

	void RetabAllTextDocuments(int newtabstops);

public:
	CQuincyApp();
	~CQuincyApp();

	BOOL CQuincyApp::FirstInstance();

	const OSVERSIONINFO& OSVersion() const
		{ return osversion; }

	// ----- IDE methods
	const int Tabstops() const
		{ return m_tabstops; }
	const int TabOption() const
		{ return m_taboption; }
	const int MaxUndos() const
		{ return m_maxundos; }
	const bool AutoIndentOption() const
		{ return m_bAutoindent; }
	const bool SyntaxColorsOption() const
		{ return m_bSyntaxColors; }
	const GetMargin() const
		{ return 2; }		// set an option later? for "off" maybe a la devstudio
	void EditorScreenFont(CFont* font, int ht, int wd, int wt);
	CQuincyDoc* GetProjectDocument(CString* pstrPath = 0);
	CQuincyView* GetProjectView();
	CTextDocument* GetTextDocument(CString pstrPath);
	CTextView* GetTextView(CString pstrPath);
	CString GetFileName(const CString& rstrPath);
	CString GetFilePath(const CString& rstrPath);
	void SaveOpenDocuments();
	void SaveAllDocuments(bool prompt = false);
	void SaveDialogWindowPosition(const CString& strWindow, CWnd* pWnd);
	void RestoreDialogWindowPosition(const CString& strWindow, CWnd* pWnd);
	CWnd* MaximizeDocument(const CString& strDocument);
	void SetBypassChangeTest();
	void BringToTop();
	void SerializeOptions(CArchive& ar, CStringArray& array);
	void SerializeProjectOptions(CArchive& ar, int nSig, int variant);
	void InvalidateAllViews(bool rebuildfont = false);
	void RunResourceEditor(const CString& strItem = CString());
	void RunFluid(const CString& strItem = CString());
	void RunCommandPrompt(const CString& strItem = CString());
	bool IsOnCDROM(const CString& strFileSpec);
	bool PrintLineNumbers() const
		{ return m_bPrintLineNos; }
	void SetPrintLineNumbers(bool bset)
		{ m_bPrintLineNos = bset; }
	const CStringArray& GetIncludeArray() const
		{ return m_Includes; }
	const CStringArray& GetDefinesArray() const
		{ return m_Defines; }
	const CStringArray& GetLibraryArray() const
		{ return m_Libs; }
	int CQuincyApp::DefaultFontHeight() const
		{ return m_defaultfontheight; }
	int CQuincyApp::DefaultFontWidth() const
		{ return m_defaultfontwidth; }

//	bool ToggleMenuCommand(int id);
	void SetMenuCommand(int id);
	void ResetMenuCommand(int id);

	COLORREF BackgroundColor() const
		{ return m_bSyntaxColors ? m_backgroundcolor : RGB(255,255,255); }
	COLORREF NormalColor() const
		{ return m_bSyntaxColors ? m_normalcolor : RGB(0,0,0); }
	COLORREF KeywordColor() const
		{ return m_keywordcolor; }
	COLORREF CommentColor() const
		{ return m_commentcolor; }
	COLORREF StringColor() const
		{ return m_stringcolor; }
	bool StrictANSI() const
		{ return m_bStrict; }
	bool C99() const
		{ return m_bC99; }
	bool AllWarnings() const
		{ return m_bWarnType == 1; }
	bool NoWarnings() const
		{ return m_bWarnType == 2; }

	bool SelectFolder(const char* title, CString* strpath);

	// ---- help methods
	CString QuincyHtmlPath() const
		{ return m_strQuincyInstallPath + "\\html\\quincy2005\\"; }

	CString ProgrammerHelpPath() const
		{ return m_strQuincyInstallPath + "\\html\\programmerhelp\\"; }

	void HtmlHelp(char* htmfile, int name);

	// --- beautifier methods
	int BeautifierStyle() const
		{ return m_style; }
	CString BeautifierCommand() const
		{ return m_command; }
	void SetBeautifierStyle(int style)
		{ m_style = style; }
	void SetBeautifierCommand(CString& command)
		{ m_command = command; }

	bool BeautifierIsInstalled() const
		{ return m_bAStyleIsInstalled; }

	CString shellCommand() const;

/* No tutorial since Quincy 2005 v1.1
#ifdef TYCPP
	// ----- tutorial methods
	void ReadTutorial();
	void WriteTutorial(const CString& strTutorial);
	bool IsTutorial(const CString& strFileName);
	void LoadTutorials();
	void CreateTutorialDialog();
	void OpenTutorial(const CString& strTut);
	void SetTutorialDisplay(bool bOnOff)
		{  m_bTutorialDisplayed = bOnOff; }

#endif
*/

	// ----- compiler methods
	Compiler& GetCompiler()
		{ ASSERT(m_pCompiler != 0); return *m_pCompiler; }
	int CompareFileTimes(CString& strFile1, CString& strFile2);
	bool SelectFileAndLine(const CString& strFile, int nline);
	void SelectErrorLine(int nsel);
	void SelectGrepLine(int nsel);
	bool CanCompile() const
		{ return m_bCompilerIsInstalled; }
	bool IsLibraryTarget();
	bool IsGUITarget();
	bool IsFLTKTarget();
	bool IsBGITarget();
	bool IsKoolplotTarget();
	bool IsDLLTarget();
	bool IsWithConsole();
	bool IsFLTK_Forms();
	bool IsFLTK_OpenGL();
	bool IsFLTK_Images();
	bool IsProjectFileLoaded();
	void SetBuildingCPP(bool bSet);
	bool CompileRunning() const;
	const CString& CompilerPath() const
		{ return m_strCompiler; }
	const CString& RIncludePath() const
		{ return m_strRIncludePath; }
	const CString& XIncludePath() const
		{ return m_strXIncludePath; }
	const CString& ToolsPath() const
		{ return m_strToolsPath; }
	const CString& LCCPath() const
		{ return m_strLCCPath; }
	bool IsAllWarnings() const;
	bool IsNoWarnings() const;
	bool IsAddingDebugInfo() const
		{ return m_bDebugging; }
	int OptimizeLevel() const
		{ return m_nOptimize; }
	bool IncludeRTTI() const
		{ return m_bRTTI; }
	bool IncludeExceptions() const
		{ return m_bExceptions; }
	const CString& IncludePath() const
		{ return m_strIncludePath; }
	const CString& CmdLineOptions() const
		{ return m_strCmdLineOptions; }
	const CString& LinkerOptions() const
		{ return m_strLinkerOptions; }
	const CString& LibPath() const
		{ return m_strLibPath; }
	const CString& XLibPath() const
		{ return m_strXLibPath; }

	const CString& StartupCode() const
		{ return m_strStartupCode; }
	const CString& QuincyBinPath() const
		{ return m_strQuincyBinPath; }
	const CString& QuincyInstallPath() const
		{ return m_strQuincyInstallPath; }
	CString GdbPath() const
		{ 
			return m_strDebugger;
/*
#ifdef CYGWIN_GDB
			m_strQuincyInstallPath + "\\gdb\\"; 
#else
			m_strToolsPath;
#endif
*/
		}
	void CloseErrorLog();

	// ----- executor methods
	void GetCommandLine(CString& strCmdLine);
	CString GetProjectRuntimeDirectory();
	const CString& GetRuntimeDirectory() const
		{ return m_strRuntimeDirectory; }
	const CString& GetTemporaryDirectory() const
		{ return m_strTempPath; }
	void ChangeToRuntimeDirectory(CString& strCmd);
	bool IsConsoleApplication();
	void ParseFileSpec(CString& strFileSpec, CString& strCmdLine, int nIndex);

	// ------ editor methods
	void ShowLineColumn(int nLine, int nColumn);
	int FontHeight() const 
		{ return m_fontheight; }
	int FontWidth()  const 
		{ return m_fontwidth; }
	int FontWeight() const 
		{ return m_fontweight; }
//	char* FontFace()
//		{ return m_fontface.GetBuffer(0); }
	void SetFontHeight(int ht) 
		{ m_fontheight = ht; }
	void SetFontWidth(int wd) 
		{ m_fontwidth = wd; }
	void SetFontWeight(int wt) 
		{ m_fontweight = wt; }
//	void SetFontFace(const char* f)
//		{ m_fontface = f; }

	// ------- debugger methods
	void StartProgram(CString& strCmd);
	void DebugProgram(CString strCmd, bool bStepping = false);
	bool TestProgramChanged();
	bool StepProgram();
	void StepOut();
	bool StepTo(const CString& strFile, int nLineNo);
	bool StopDebugging();
	bool ExecuteRunningProgram();
	Debugger* GetDebugger(bool bVerify = true) const;
//	const CString& WorkingPath() const;
	void StopDebugger();
	void SetStepping() { stepping = true; }

	// ------- gdb interface methods
	void CreateGdbConsole();
	GdbConsole* GetGdbConsole() { return m_pdlgGdbConsole; }
	void DisplayGdbText(char* txt);
	void AppendNextText()
		{ appendnexttext = true; }
	void ClearGdbConsole();

	// ----- breakpoint methods
	void ToggleBreakpoint(const CString& strFile, int nLineNo);
	void AddBreakpoint(const CString& strFile, int nLineNo);
	int BreakpointCount() const
		{ return breakpoints.size(); }
	void AdjustTextLine(const CString& strFile, int nLineno, int nAdjust);
	void DeletedTextLine(const CString& strFile, int nLineno)
		{ AdjustTextLine(strFile, nLineno, -1); }
	void InsertedTextLine(const CString& strFile, int nLineno)
		{ AdjustTextLine(strFile, nLineno, 1); }
	bool IsBreakpoint(const CString& strFile, int nLineno);
	std::set<Breakpoint>& GetProgrammedBreakpoints()
		{ return breakpoints; }
	void ClearBreakpoints()
		{ breakpoints.clear(); }
	Breakpoint SteptoBreakpoint();

	// ------ watch and examine methods
	void CreateWatchWindow();
	void GetVariableValue(const CString& strVarName, CWnd* wnd = 0);
	void SetVariableValue(const CString& strVarName, const CString& strVarValue);
	CWatchDialog* GetWatchDialog() { return m_pdlgWatch; }
	void PostWatchList();

	// ------ command line console methods
	CString Enquote(const CString& str) const;


	void RegisterView(CEditorView* pView)
		{ m_pEditorView = pView; }

	CEditorView* GetEditorView() const
		{ return m_pEditorView; }

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuincyApp)
	public:
	virtual BOOL InitInstance();
	virtual CDocument* OpenDocumentFile(LPCTSTR lpszFileName);
	virtual BOOL OnIdle(LONG lCount);
	virtual int ExitInstance();
	//}}AFX_VIRTUAL

// Implementation

	//{{AFX_MSG(CQuincyApp)
	afx_msg void OnAppAbout();
	afx_msg void OnStop();
	afx_msg void OnUpdateStop(CCmdUI* pCmdUI);
	afx_msg void OnOptions();
	afx_msg void OnUpdateDebugClearbreakpoints(CCmdUI* pCmdUI);
	afx_msg void OnDebugClearbreakpoints();
	afx_msg void OnDebugStepover();
	afx_msg void OnUpdateDebugExamine(CCmdUI* pCmdUI);
	afx_msg void OnDebugExamine();
	afx_msg void OnDebugWatch();
	afx_msg void OnUpdateDebugStepover(CCmdUI* pCmdUI);
	afx_msg void OnHelp();
	afx_msg void OnProgrammerHelp();
	afx_msg void OnTycpp();
	afx_msg void OnResourceeditor();
	afx_msg void OnToolsFluid();
	afx_msg void OnToolsCommandPrompt();
	afx_msg void OnGrep();
	afx_msg void OnUpdateGrep(CCmdUI* pCmdUI);
	afx_msg void OnUpdateResourceeditor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsFluid(CCmdUI* pCmdUI);
	afx_msg void OnUpdateToolsCommandPrompt(CCmdUI* pCmdUI);
	afx_msg void OnFileOpen();
	afx_msg void OnFilePrintSetup();
	afx_msg void OnViewGdbconsole();
	afx_msg void OnUpdateHelp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateProgrammerHelp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateTycpp(CCmdUI* pCmdUI);
	afx_msg void OnUpdateProperties(CCmdUI* pCmdUI);
	afx_msg void OnProperties();
	//}}AFX_MSG
/* No tutorial since Quincy 2005 v1.1
 #ifdef TYCPP
	afx_msg void OnTycpp();
	afx_msg void OnUpdateTycpp(CCmdUI* pCmdUI);
	afx_msg void OnWritetutorial();
#endif
*/
	DECLARE_MESSAGE_MAP()
};

extern CQuincyApp theApp;

inline void CQuincyApp::SetBypassChangeTest()
{
	m_bBypassChangeTest = true;
}
inline Debugger* CQuincyApp::GetDebugger(bool bVerify) const
{
	if (bVerify)
		ASSERT(m_pDebugger);
	return m_pDebugger;
}
/*
inline const CString& CQuincyApp::WorkingPath() const
{
	return m_strWorkingPath;
}
*/
/////////////////////////////////////////////////////////////////////////////

#endif // QUINCY_H
