// QuincyView.cpp : implementation of the CQuincyView class
//

#include "stdafx.h"
#include "Quincy.h"

#include "ChildFrm.h"
#include "QuincyDoc.h"
#include "QuincyView.h"
#include "resource.h"
#include "debugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuincyView

IMPLEMENT_DYNCREATE(CQuincyView, CListView)

BEGIN_MESSAGE_MAP(CQuincyView, CListView)
	ON_WM_CONTEXTMENU()
	//{{AFX_MSG_MAP(CQuincyView)
	ON_COMMAND(ID_BUILD, OnBuild)
	ON_COMMAND(ID_BUILDALL, OnBuildAll)
	ON_COMMAND(ID_DELETE_FILE, OnDeleteFile)
	ON_COMMAND(ID_INSERT_FILE, OnInsertFile)
	ON_COMMAND(ID_EXECUTE, OnRun)
	ON_UPDATE_COMMAND_UI(ID_DELETE_FILE, OnUpdateDelete)
	ON_UPDATE_COMMAND_UI(ID_BUILD, OnUpdateBuild)
	ON_UPDATE_COMMAND_UI(ID_EXECUTE, OnUpdateExecute)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_SELECTFILE, OnSelectfile)
	ON_UPDATE_COMMAND_UI(ID_SELECTFILE, OnUpdateSelectfile)
	ON_COMMAND(ID_DEBUG_STEP, OnDebugStep)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEP, OnUpdateDebugStep)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPOVER, OnUpdateDebugStepover)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPTOCURSOR, OnUpdateDebugSteptocursor)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_ALL, OnUpdateFileSaveAll)
	ON_UPDATE_COMMAND_UI(ID_BUILDALL, OnUpdateBuild)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQuincyView construction/destruction

CQuincyView::CQuincyView()
{
	m_nExitCode = 0;
	m_bDoLink = false;
}

CQuincyView::~CQuincyView()
{
}

BOOL CQuincyView::PreCreateWindow(CREATESTRUCT& cs)
{
	cs.style |= LVS_LIST;
	return CListView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyView drawing

void CQuincyView::OnDraw(CDC* pDC)
{
	CQuincyDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyView diagnostics

#ifdef _DEBUG
void CQuincyView::AssertValid() const
{
	CListView::AssertValid();
}

void CQuincyView::Dump(CDumpContext& dc) const
{
	CListView::Dump(dc);
}

CQuincyDoc* CQuincyView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CQuincyDoc)));
	return (CQuincyDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CQuincyView message handlers

void CQuincyView::OnDeleteFile() 
{
	CListCtrl& rlist = GetListCtrl();
	int item;
	if (rlist.GetSelectedCount() > 0)
		// --- don't know how to keep selection displayed during message box display
		// --- (Win95's shell doesn't either)
		if (AfxMessageBox("Delete selected file(s)?", MB_YESNO) != IDYES)
			return;
	// --- loop through selected items, deleting them
	while (rlist.GetSelectedCount() > 0)	{
		item = rlist.GetNextItem(-1, LVNI_SELECTED);
		if (item != -1)	{
			rlist.DeleteItem(item);
			GetDocument()->SetModifiedFlag();
		}
	}
	if (rlist.GetItemCount() > 0)	{
		// --- Select the item following the deleted one
		UINT state = rlist.GetItemState(item, LVIS_SELECTED);
		rlist.SetItemState(item, LVIS_SELECTED, LVIS_SELECTED);
	}
}

void CQuincyView::OnInsertFile() 
{
	CQuincyDoc* pDoc = GetDocument();
	ASSERT(pDoc != 0);

	CFileDialog dlgfile(
		true, 0, 0, 
		OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_NOCHANGEDIR | OFN_ALLOWMULTISELECT,
		0,
		this);
	if (pDoc->IsLibraryTarget())
		dlgfile.m_ofn.lpstrFilter = "Project Files (*.c;*.cc;*.cxx;*.cpp)\0*.c;*.cc;*.cxx;*.cpp\0\0";
	else if (pDoc->IsGUITarget())	{
		dlgfile.m_ofn.lpstrFilter = "Project Files (*.c;*.cc;*.cxx;*.cpp;*.a;*.rc;*.res)\0*.c;*.cc;*.cxx;*.cpp;*.a;*.rc;*.res\0\0";
	}
	else if (pDoc->IsDLLTarget())	{
		dlgfile.m_ofn.lpstrFilter = "Project Files (*.c;*.cc;*.cxx;*.cpp;*.a;*.def)\0*.c;*.cc;*.cxx;*.cpp;*.a;*.def\0\0";
	}
	else	{
		dlgfile.m_ofn.lpstrFilter = "Project Files (*.c;*.cc;*.cxx;*.cpp;*.a)\0*.c;*.cc;*.cxx;*.cpp;*.a\0\0";
	}

	dlgfile.m_ofn.lpstrTitle = "Insert File(s)";
	if (dlgfile.DoModal() == IDOK)	{
		char *pathptr = dlgfile.m_ofn.lpstrFile;
		ASSERT(pathptr != 0);
		char *fileptr = pathptr+strlen(pathptr)+1;
		if (*fileptr == '\0')	{
			// only one file, so the dialog appends it to the path string
			while (*--fileptr != '\\')
				if (*fileptr == ':' || fileptr == pathptr)
					break;
			if (*fileptr == '\\')
				*fileptr++ = '\0';		// convert path\file to path \0 file
		}

		char path[MAX_PATH];
		_getcwd(path, MAX_PATH);
		CString strCurrentPath(path);
		CString strFile(fileptr);
		CString strSelectedPath(pathptr);

		bool islib = (strFile.Left(3).CompareNoCase("lib") == 0);

		if (!islib && strSelectedPath.CompareNoCase(strCurrentPath) != 0)	{
			if (AfxMessageBox("Selected file(s) not in project folder. Copy them?", MB_YESNO | MB_ICONQUESTION) == IDYES)	{
				char* fptr = fileptr;
				while (*fptr)	{
					CString strDest(fptr);
					if (_access(strDest, 0) || AfxMessageBox(strDest + CString(" exists. Overwrite?"), MB_YESNO | MB_ICONQUESTION) == IDYES)	{
						CString strSrc(strSelectedPath + "\\" + strDest);
						CopyFile(strSrc, strDest, false);
					}
					fptr += strlen(fptr) + 1;
				}
			}
			else
				return;
		}

		CListCtrl& rlist = GetListCtrl();
		while (*fileptr)	{
			CString strFile(fileptr);

			LV_FINDINFO info = {LVFI_STRING, strFile, 0};
			if (rlist.FindItem(&info) == -1)	{
				int item = rlist.GetNextItem(-1, LVNI_SELECTED);
				if (item == -1)
					item = rlist.GetItemCount();
				rlist.InsertItem(item, strFile);
				pDoc->SetModifiedFlag();
			}
			fileptr += strlen(fileptr) + 1;
		}
	}
}

BOOL CQuincyView::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	bool rtn = CWnd::Create(lpszClassName, lpszWindowName, dwStyle, rect, pParentWnd, nID, pContext);
	// --- register with parent frame class 
	// --- register with parent frame class 
	CChildFrame* pParent = (CChildFrame*)GetParentFrame();
	ASSERT(pParent != 0);
	pParent->RegisterView(this);
	return rtn;
}

void CQuincyView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	OnSelectfile();
}

void CQuincyView::OnSelectfile() 
{
	CListCtrl& rlist = GetListCtrl();
	int item = -1;
	while ((item = rlist.GetNextItem(item, LVNI_SELECTED)) != -1)	{
		CString strItem = rlist.GetItemText(item, 0);
		if (strItem.Right(4).CompareNoCase(".res") == 0)
			// --- launch the resource editor
			theApp.RunResourceEditor(strItem);
		else	{
			bool islib = (strItem.Right(2).CompareNoCase(".a") == 0);
			if (!islib)
				theApp.OpenDocumentFile(strItem);
		}
	}
}

void CQuincyView::OnUpdateSelectfile(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(GetSelectedCount() != 0);
}

void CQuincyView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
	if (bActivate)
		theApp.ShowLineColumn(0, 0);
	CListView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

void CQuincyView::OnUpdateDebugStep(CCmdUI* pCmdUI) 
{
	if (GetDocument()->IsLibraryTarget() || 
			GetDocument()->IsDLLTarget() || 
				theApp.CompileRunning() || 
					!theApp.CanCompile())	{
		pCmdUI->Enable(false);
		return;
	}
//	Debugger* pDebugger = theApp.GetDebugger(false);
//	pCmdUI->Enable(pDebugger == 0 || !pDebugger->IsInProgram());
}

void CQuincyView::OnUpdateDebugStepover(CCmdUI* pCmdUI) 
{
	OnUpdateDebugStep(pCmdUI);
}

void CQuincyView::OnUpdateDebugSteptocursor(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);
}

// ---- Delete enabled only if project has selected files
void CQuincyView::OnUpdateDelete(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(GetSelectedCount() != 0);
}

// ---- Build, Execute commands enabled only if project has files 
//      and nothing is running
void CQuincyView::OnUpdateBuild(CCmdUI* pCmdUI) 
{
	Debugger* pDebugger = theApp.GetDebugger(false);
	pCmdUI->Enable(GetItemCount() != 0 && !theApp.CompileRunning() && theApp.CanCompile() && pDebugger == 0);
}

void CQuincyView::OnUpdateExecute(CCmdUI* pCmdUI) 
{
	if (GetDocument()->IsLibraryTarget() || GetDocument()->IsDLLTarget())
		pCmdUI->Enable(false);
	else	{
		Debugger* pDebugger = theApp.GetDebugger(false);
		if (pDebugger != 0 && !pDebugger->isInProgram())
			pCmdUI->Enable(true);
		else
			OnUpdateBuild(pCmdUI);
	}
}

void CQuincyView::OnUpdateFileSaveAll(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(true);
}

