// ------ debugger.h

#ifndef DEBUGGER_H
#define DEBUGGER_H

#include "consoleapp.h"
#include "string"
#include "queue"

class Debugger	{
	char* m_pOldPath;			// original working logged-on subdirectory
	int m_nDrive;				// original working drive
	ConsoleApp* gdb;
	bool atprompt;
	bool watching;
	char lastcommand[100];

	static Debugger* pDebugger;
	CWnd* ExamineWnd;
	CString strRedirect;

	// queue of commands posted to be executed as the prompt comes up
	std::queue<std::string, std::deque<std::string> > cmds;

	// filename and line number of current source code file being stepped through
	std::string steppingsrc;
	int steppinglineno;
	// filename and line number of current source code file being debugged
	std::string currentsrc;
	int currentlineno;

	int watchct;		// count of watch variables
	int watchiter;		// watch iterator
	CString* Expressions;

	// the stack level
	std::string frame;
	std::string mainframe;
	bool infosent;

	void SendCommand(char* cmd);
	static void Collect(DWORD bufct);
	void CollectGdbMessages(DWORD bufct);
	static void Notify();
	void NotifyTermination();
	void ShowPCCaret(bool bOnOff);

	bool IsText(const char* buf, const char* txt) const;
	void SetTempBreakpoint(const Breakpoint& bp);
	void PostResponse(const char* res);
	void DisplayData(const char* cp);
	void IterateWatches();
	void UndoWatchDisplays();
	void ConvertSlashes(std::string& str);


public:
	Debugger();
	~Debugger();
	void LoadDebugger(std::string strCmd);
	void StartProgram();
	void StepIntoProgram();
	void Stop();
	bool isInProgram() const
		{ return !atprompt; }
	void PostCommand(const char* cmd);
	int CurrentLineNo() const;
	const CString* CurrentSrcFile() const;
	bool ExecuteRunningProgram();
	bool StepProgram();
	bool StepOver();
	void StepOut();
	bool StepTo(const CString& strFile, int nLineNo);
	void SetBreakpoint(Breakpoint& bp);
	void ClearBreakpoint(Breakpoint& bp);
	void SelectSteppingSourceLine();
	bool AtStackLevelZero()
		{ return frame == mainframe; }
	void GetVariableValue(const CString& strVarName, CWnd* wnd);
	void SetVariableValue(const CString& strVarName, const CString& strVarValue);
	void SetWatchExpressions(CString* exps, int ct);
};

#endif


