// EditorDoc.h : interface of the CEditorDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_EDITORDOC_H__408454CD_548A_11D2_A779_00C0A80034F0__INCLUDED_)
#define AFX_EDITORDOC_H__408454CD_548A_11D2_A779_00C0A80034F0__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include <vector>
#include <string>

struct EditorPosition	{
	unsigned int row;
	unsigned int column;
	EditorPosition(int rw = 0, int col = 0) : row(rw), column(col) { }
};

struct ViewContext	{
	EditorPosition scroller;
	EditorPosition pos;
};

struct DocPosition : EditorPosition {
	DocPosition(unsigned int rw = 0, unsigned int col = 0) : EditorPosition(rw, col) { }
};
struct StrPosition : EditorPosition {
	StrPosition(unsigned int rw = 0, unsigned int col = 0) : EditorPosition(rw, col) { }
};
struct CharPosition : EditorPosition {
	CharPosition(unsigned int rw = 0, unsigned int col = 0) : EditorPosition(rw, col) { }
};

class CEditorView;

class CEditorDoc : public CDocument
{
	std::vector<std::string> doctext;
	class UndoEditorData* m_pUndoEditorData;
	unsigned int m_linewidth;
	// ---- collect character inserts for bulk undos
	int undorow, undocolumn;

protected: // create from serialization only
	CEditorDoc();
	DECLARE_DYNCREATE(CEditorDoc)
	void BuildEmptyDocument();

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CEditorDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CEditorDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	unsigned int linecount() const
		{ return doctext.size(); }
	unsigned int linewidth() const
		{ return m_linewidth; }
	const std::string& textline(unsigned int lineno) const
		{ return doctext[lineno]; }
	char textchar(unsigned int lineno, unsigned int column) const
		{ return doctext[lineno] [column]; }
	void replaceline(unsigned int lineno, const std::string& str, bool bterminate = true);
	void insertline(unsigned int lineno, const std::string& str, bool bterminate = true);
	void appendline(const std::string& str, bool bterminate = true);
	// Add a terminating Carriage return to the last line if one is not there
	void appendLastCR();
	void deleteline(unsigned int lineno, bool bterminate = true);
	void insertchar(char ch, unsigned int row, unsigned int column, bool bterminate = true);
	bool deletechar(unsigned int row, unsigned int column, bool bterminate = true);
	static void detab(std::string& str, int tabstops = -1);
	static void entab(std::string& str);
	CEditorView* GetView() const;
	void UpdateView();
	void ResetUndoData();
	void TerminateUndoCollection();
	void Retab(int newtabstops);
	void ReplaceDocument(std::vector<std::string>& newdoc);

	////////////////////////////////////////////////////////
	//
	// Undo/Redo functions
	//
	// --- called from within undo/redo library
	void Replace(DocPosition pos, const std::vector<std::string>& rDoc);
	const std::vector<std::string> GetDatum(DocPosition);

	void Insert(StrPosition pos, const std::string& rStr);
	void Delete(StrPosition pos);
	void Replace(StrPosition pos, const std::string& rStr);
	const std::string& GetDatum(StrPosition pos);

	void Insert(CharPosition pos, char Char);
	void Delete(CharPosition pos);
	void Replace(CharPosition pos, char Char);
	char GetDatum(CharPosition pos);

	void SetUndoContext(ViewContext vc);
	ViewContext GetUndoContext() const;
	bool CanUndo() const;
	bool CanRedo() const;

	//
	////////////////////////////////////////////////////////

// Generated message map functions
	//{{AFX_MSG(CEditorDoc)
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnEditUndo();
	afx_msg void OnUpdateEditRedo(CCmdUI* pCmdUI);
	afx_msg void OnEditRedo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_EDITORDOC_H__408454CD_548A_11D2_A779_00C0A80034F0__INCLUDED_)
