// EditorOptions.cpp : implementation file
//

#include "stdafx.h"
#include "quincy.h"
#include "OptionsSheet.h"
#include "EditorOptions.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditorOptions property page

IMPLEMENT_DYNCREATE(CEditorOptions, CPropertyPage)

CEditorOptions::CEditorOptions() : CPropertyPage(CEditorOptions::IDD)
{
	//{{AFX_DATA_INIT(CEditorOptions)
	m_AutoIndent = false;
	m_SyntaxColors = false;
	m_MaxUndos = _T("");
	m_bold = FALSE;
	m_taboption = -1;
	//}}AFX_DATA_INIT
	m_nTabstops = 4;
	m_nMaxundos = 1024;
	DefaultColors();
}

CEditorOptions::~CEditorOptions()
{
}

void CEditorOptions::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CEditorOptions)
	DDX_Control(pDX, IDC_MAXUNDOS_SPIN, m_MaxUndosSpin);
	DDX_Control(pDX, IDC_SAMPLECODE, m_SampleCode);
	DDX_Control(pDX, IDC_BACKGROUND, m_Background);
	DDX_Control(pDX, IDC_NORMAL, m_Normal);
	DDX_Control(pDX, IDC_STRINGS, m_String);
	DDX_Control(pDX, IDC_KEYWORDS, m_Keyword);
	DDX_Control(pDX, IDC_COMMENTS, m_Comment);
	DDX_Control(pDX, IDC_TABSTOPS_SPIN, m_TabstopsSpin);
	DDX_Control(pDX, IDC_TABSTOPS, m_Tabstops);
	DDX_Check(pDX, IDC_AUTOINDENT, m_AutoIndent);
	DDX_Check(pDX, IDC_SYNTAXCOLORS, m_SyntaxColors);
	DDX_Text(pDX, IDC_MAXUNDOS, m_MaxUndos);
	DDX_Check(pDX, IDC_BOLD, m_bold);
	DDX_Radio(pDX, IDC_TABS, m_taboption);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CEditorOptions, CPropertyPage)
	//{{AFX_MSG_MAP(CEditorOptions)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_DEFAULTCOLORS, OnDefaults)
	ON_NOTIFY(-722, IDC_TABSTOPS_SPIN, OnSpin )
	ON_BN_CLICKED(IDC_SYNTAXCOLORS, OnSyntaxcolors)
	ON_BN_CLICKED(IDC_FONTPLUS, OnFontplus)
	ON_BN_CLICKED(IDC_FONTMINUS, OnFontminus)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BOLD, OnBold)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEditorOptions message handlers

BOOL CEditorOptions::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	m_TabstopsSpin.SetRange(1,8);
	m_TabstopsSpin.SetPos(m_nTabstops);

	m_MaxUndosSpin.SetRange(100, 8192);
	m_MaxUndosSpin.SetPos(m_nMaxundos);

	m_SampleCode.m_syntaxcolor = m_SyntaxColors;
	m_SampleCode.m_fontheight = theApp.FontHeight();
	m_SampleCode.m_fontwidth  = theApp.FontWidth();
	m_SampleCode.m_fontweight = theApp.FontWeight();

	if (m_SampleCode.m_fontweight != FW_NORMAL)	{
		m_bold = TRUE;
		UpdateData(FALSE);
	}

	return true;
}

void CEditorOptions::OnOK() 
{
	m_nTabstops = m_TabstopsSpin.GetPos();
	m_nMaxundos = m_MaxUndosSpin.GetPos();
	CPropertyPage::OnOK();
}

int CEditorOptions::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CPropertyPage::OnCreate(lpCreateStruct) == -1)
		return -1;
	UpdateColors();
	m_SampleCode.m_tabstops = m_nTabstops;

	return 0;
}

void CEditorOptions::GetColor(CColorBox& wnd, CPoint point, COLORREF& cr)
{
	WINDOWPLACEMENT wp;
	wnd.GetWindowPlacement(&wp);
	CRect rc(wp.rcNormalPosition);
	if (rc.PtInRect(point))	{
		CColorDialog cdlg(cr);
		if (cdlg.DoModal() == IDOK)	{
			cr = cdlg.GetColor();
			Invalidate(false);
		}
	}
}

void CEditorOptions::OnLButtonDown(UINT nFlags, CPoint point) 
{
	GetColor(m_Background, point, m_backgroundcolor);
	GetColor(m_Normal,     point, m_normalcolor);
	GetColor(m_Comment,    point, m_commentcolor);
	GetColor(m_String,     point, m_stringcolor);
	GetColor(m_Keyword,    point, m_keywordcolor);
	UpdateColors();
	CPropertyPage::OnLButtonDown(nFlags, point);
}

void CEditorOptions::DefaultColors()
{
	m_backgroundcolor = RGB(255,255,255);
	m_normalcolor     = RGB(0,0,0);
	m_stringcolor     = RGB(255,0,0);
	m_keywordcolor    = RGB(0,0,255);
	m_commentcolor    = RGB(0,128,0);
}

void CEditorOptions::OnDefaults() 
{
	DefaultColors();
	UpdateColors();
	m_SampleCode.DefaultFont();
	m_taboption = 0;
	m_nTabstops = 4;
	m_nMaxundos = 1024;
	m_SampleCode.m_syntaxcolor = true;
	m_bold = false;
	UpdateData(false);
	Invalidate(false);
	PostMessage(WM_COMMAND, ID_RETABSAMPLECODE);
	m_TabstopsSpin.SetPos(m_nTabstops);
	m_MaxUndosSpin.SetPos(m_nMaxundos);
}

void CEditorOptions::UpdateColors() 
{
	m_SampleCode.m_backgroundcolor = m_Background.color = m_backgroundcolor;
	m_SampleCode.m_normalcolor     = m_Normal.color     = m_normalcolor;
	m_SampleCode.m_stringcolor     = m_String.color     = m_stringcolor;
	m_SampleCode.m_keywordcolor    = m_Keyword.color    = m_keywordcolor;
	m_SampleCode.m_commentcolor    = m_Comment.color    = m_commentcolor;
}

BOOL CEditorOptions::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	if (wParam == ID_RETABSAMPLECODE)	{
		m_nTabstops = m_TabstopsSpin.GetPos();
		m_SampleCode.m_tabstops = m_nTabstops;
		m_SampleCode.Invalidate();
	}
	return CPropertyPage::OnCommand(wParam, lParam);
}

void CEditorOptions::OnSpin(NMHDR* pNotifyStruct, LRESULT* result)
{
	PostMessage(WM_COMMAND, ID_RETABSAMPLECODE);
	*result = 0;
}

void CEditorOptions::OnSyntaxcolors() 
{
	UpdateData();
	m_SampleCode.m_syntaxcolor = m_SyntaxColors;
	m_SampleCode.Invalidate();
}

BOOL CEditorOptions::OnSetActive() 
{
	static_cast<COptionsSheet*>(GetParent())->RegisterActiveIndex();
	return CPropertyPage::OnSetActive();
}

void CEditorOptions::OnFontplus() 
{
	m_SampleCode.IncreaseFont();	
}

void CEditorOptions::OnFontminus() 
{
	m_SampleCode.DecreaseFont();	
}

void CEditorOptions::OnBold() 
{
	UpdateData();
	m_SampleCode.m_fontweight = m_bold ? FW_SEMIBOLD : FW_NORMAL;	
	m_SampleCode.Invalidate();
}
