// ------- Editorundo.h

#ifndef EDITORUNDO_H
#define EDITORUNDO_H

#include "undo.h"
#include "EditorDoc.h"

namespace undo = DDJCProgrammingColumnUndo;

// --------------------------------------------------------------------------
class UndoReplaceDoc : public 
undo::UndoReplaceNode<CEditorDoc, std::vector<std::string>, DocPosition, ViewContext>
{
public:
	UndoReplaceDoc(CEditorDoc* pEditorDoc, DocPosition pDoc, bool bTerminator) throw() : 
		undo::UndoReplaceNode<CEditorDoc, std::vector<std::string>, DocPosition, ViewContext>
			(*pEditorDoc, pDoc, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoInsertStr : public 
undo::UndoInsertNode<CEditorDoc, std::string, StrPosition, ViewContext>
{
public:
	UndoInsertStr(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator) throw() : 
		undo::UndoInsertNode<CEditorDoc, std::string, StrPosition, ViewContext>
			(*pEditorDoc, pStr, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoDeleteStr : public 
		undo::UndoDeleteNode<CEditorDoc, std::string, StrPosition, ViewContext>
{
public:
	UndoDeleteStr(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator) throw() : 
		undo::UndoDeleteNode<CEditorDoc, std::string, StrPosition, ViewContext>
			(*pEditorDoc, pStr, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoReplaceStr : public 
		undo::UndoReplaceNode<CEditorDoc, std::string, StrPosition, ViewContext>
{
public:
	UndoReplaceStr(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator) throw() : 
		undo::UndoReplaceNode<CEditorDoc, std::string, StrPosition, ViewContext>
			(*pEditorDoc, pStr, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoInsertChar : public 
		undo::UndoInsertNode<CEditorDoc, char, CharPosition, ViewContext>
{
public:
	UndoInsertChar(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator) throw() : 
		undo::UndoInsertNode<CEditorDoc, char, CharPosition, ViewContext>
			(*pEditorDoc, pChar, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoDeleteChar : public 
		undo::UndoDeleteNode<CEditorDoc, char, CharPosition, ViewContext>
{
public:
	UndoDeleteChar(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator) throw() : 
		undo::UndoDeleteNode<CEditorDoc, char, CharPosition, ViewContext>
			(*pEditorDoc, pChar, bTerminator)
		{	}
};
// --------------------------------------------------------------------------
class UndoReplaceChar : public 
		undo::UndoReplaceNode<CEditorDoc, char, CharPosition, ViewContext>
{
public:
	UndoReplaceChar(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator) throw() : 
		undo::UndoReplaceNode<CEditorDoc, char, CharPosition, ViewContext>
			(*pEditorDoc, pChar, bTerminator)
		{	}
};


// --------------------------------------------------------------------------
class UndoEditorData : public undo::UndoData<CEditorDoc>
{
	static bool reportedundofull;		// true after one report of undo full this session
	void TestUndoFull();
public:
	UndoEditorData(CEditorDoc* pEditorDoc, int nMaxUndos) : 
				undo::UndoData<CEditorDoc>(*pEditorDoc, nMaxUndos)
		{	}
	void AddReplaceDocUndo(CEditorDoc* pEditorDoc, DocPosition pStr, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoReplaceDoc(pEditorDoc, pStr, bTerminator));
		TestUndoFull();
	}
	void AddInsertStrUndo(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoInsertStr(pEditorDoc, pStr, bTerminator));
		TestUndoFull();
	}
	void AddDeleteStrUndo(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoDeleteStr(pEditorDoc, pStr, bTerminator));
		TestUndoFull();
	}
	void AddReplaceStrUndo(CEditorDoc* pEditorDoc, StrPosition pStr, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoReplaceStr(pEditorDoc, pStr, bTerminator));
		TestUndoFull();
	}
	void AddInsertCharUndo(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoInsertChar(pEditorDoc, pChar, bTerminator));
		TestUndoFull();
	}
	void AddDeleteCharUndo(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoDeleteChar(pEditorDoc, pChar, bTerminator));
		TestUndoFull();
	}
	void AddReplaceCharUndo(CEditorDoc* pEditorDoc, CharPosition pChar, bool bTerminator = true)
	{
		AddUndoNode(new (this) UndoReplaceChar(pEditorDoc, pChar, bTerminator));
		TestUndoFull();
	}
};
#endif

