// ----- grep.cpp

#include "stdafx.h"
#include "Quincy.h"
#include "grep.h"
#include "EditorView.h"
#include "consoleapp.h"

char* Grep::extensions[] = {
	"h", "c", "cc", "cpp", "cxx", "rc"
};

Grep* Grep::pGrep;

Grep::Grep() : grepcount(sizeof(extensions) / sizeof(char*))
{
	status = idle;
	m_pdlgGrepResult = new GrepResult;
	m_pdlgGrepInput = new GrepInput;
	m_bGrepInputCreated = false;
	m_bGrepResultCreated = false;
	grepstepper = 0;
	m_pConsoleApp = new ConsoleApp(theApp.Enquote(theApp.QuincyBinPath() + "\\grep.exe"), &Notify, &Collect);
	pGrep = this;
}

Grep::~Grep()
{
	delete m_pdlgGrepResult;
	delete m_pdlgGrepInput;
	delete m_pConsoleApp;
	pGrep = 0;
}

void Grep::OnGrep() 
{
	ASSERT(m_pdlgGrepInput != 0);
	bool grepping;

	if (theApp.GetEditorView() != 0)
		m_pdlgGrepInput->m_strGrepInput = theApp.GetEditorView()->SelectedText().c_str();

	if (m_pdlgGrepInput->DoModal() == IDOK)	{
		if (!m_pdlgGrepInput->m_strGrepInput.IsEmpty())	{

			ASSERT(m_pdlgGrepResult != 0);
			if (m_bGrepResultCreated != true)	{
				m_pdlgGrepResult->Create(IDD_GREPS);
				m_bGrepResultCreated = true;
			}

			m_pdlgGrepResult->m_ResultList.ResetContent();
			m_pdlgGrepResult->Invalidate();

			GrepLog.clear();

			m_nGrepCount = 0;

			m_pdlgGrepResult->ShowWindow(SW_SHOW);

			m_strParams = " -n ";

			if (!m_pdlgGrepInput->m_bMatchCase)
				m_strParams += "-i ";
			if (m_pdlgGrepInput->m_bMatchWord)
				m_strParams += "-w ";
			m_strParams += "\"" + m_pdlgGrepInput->m_strGrepInput + "\"";

			grepstepper = 0;
			RunGrep(extensions[grepstepper]);
		}
	}
}

void Grep::Notify()
{
	ASSERT(pGrep != 0);
	pGrep->NotifyTermination();
}

void Grep::NotifyTermination()
{
	if (++grepstepper < grepcount)
		RunGrep(extensions[grepstepper]);
	else if (m_nGrepCount == 0)
		m_pdlgGrepResult->m_ResultList.AddString("No matches found");
}


void Grep::Collect(DWORD bufct)
{
	ASSERT(pGrep != 0);
	pGrep->CollectMessages(bufct);
}

void Grep::CollectMessages(DWORD bufct)
{
	char *line = new char[bufct+1];
	ASSERT(m_pConsoleApp);
	if (m_pConsoleApp->ReadConsole(line, bufct) != 0)	{
		// ------ put entry into grep response
		CString strLine(line);
		if (strLine.Find("No such file or directory") == -1)	{
			if (strLine.Find("Invalid argument") == -1)	{
				if (strLine.Find("usage") == -1)	{
					int ndx;
					do
						if ((ndx = strLine.Find('\t')) != -1)
							strLine.SetAt(ndx, ' ');
					while (ndx != -1);
					if ((ndx = strLine.Find(':')) != -1)	{
						ASSERT(m_pdlgGrepResult != 0);
						m_pdlgGrepResult->m_ResultList.AddString(strLine);
						CString strFile = strLine.Left(ndx);
						int lineno = atoi(strLine.GetBuffer(0) + ndx + 1);
						ErrorMessage ell;
						ell.m_strFileSpec = strFile;
						ell.m_nLineNumber = lineno;
						GrepLog.push_back(ell);;
						++m_nGrepCount;
					}
				}
			}
		}
	}
	delete line;
}

void Grep::RunGrep(const CString& params)
{
	ASSERT(m_pConsoleApp != 0);
	m_pConsoleApp->Run(m_strParams + " *." + params);
}

void Grep::Stop()
{
	ASSERT(m_pConsoleApp);
	ASSERT(m_pdlgGrepResult);
	m_pdlgGrepResult->m_ResultList.AddString("Grep stopped by user");
	m_pConsoleApp->Stop();
}

void Grep::SelectGrepLine(int nsel)
{
	if (nsel != -1 && m_nGrepCount > 0 && nsel < GrepLog.size())
		theApp.SelectFileAndLine(GrepLog[nsel].m_strFileSpec, GrepLog[nsel].m_nLineNumber);
}

