// QuincyDoc.h : interface of the CQuincyDoc class
//
/////////////////////////////////////////////////////////////////////////////

class CQuincyDoc : public CDocument
{
private:
	static const int quincyVersion = 2005;
	static const int quincyVariant = 1; // 1 at version 1.2

	static CQuincyDoc* m_pOpenDocument;
	int m_nProjectType;
	BOOL m_bWithConsole;
	BOOL m_bFLTK_Forms;
	BOOL m_bFLTK_OpenGL;
	BOOL m_bFLTK_Images;
	CString m_strTarget;
	CString m_strWorking;
	CString m_strPath;
protected: // create from serialization only
	CQuincyDoc();
	DECLARE_DYNCREATE(CQuincyDoc)

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuincyDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	virtual void SetTitle(LPCTSTR lpszTitle);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CQuincyDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	bool IsConsoleApplication() const
		{ return m_nProjectType == 0; }
	bool IsGUITarget() const
		{ return m_nProjectType == 1; }
	bool IsBGITarget() const
		{ return m_nProjectType == 2; }
	bool IsKoolplotTarget() const
		{ return m_nProjectType == 3; }
	bool IsFLTKTarget() const
		{ return m_nProjectType == 4; }
	bool IsLibraryTarget() const
		{ return m_nProjectType == 5; }
	bool IsDLLTarget() const
		{ return m_nProjectType == 6; }
	bool IsWithConsole() const
		{ return m_bWithConsole; }
	bool IsFLTK_Forms() const
		{ return m_bFLTK_Forms; }
	bool IsFLTK_OpenGL() const
		{ return m_bFLTK_OpenGL; }
	bool IsFLTK_Images() const
		{ return m_bFLTK_Images; }
	const CString& TargetName() const
		{ return m_strTarget; }
	const CString& ProjectPath() const
		{ return m_strPath; }
	const CString& WorkingDirectory() const
		{ return m_strWorking; }
	static CQuincyDoc* CurrentProject()
		{ return m_pOpenDocument; }
	void DoOnProperties()
		{ OnProperties(); }
protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CQuincyDoc)
	afx_msg void OnUpdateTrue(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFalse(CCmdUI* pCmdUI);
	afx_msg void OnProperties();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
