// ------- stabs.cpp

#include "stdafx.h"
#include "stabs.h"

CStab::CStab(const std::string& filename)
{
	hasstabs = false;
	// ---- open the executable file
    std::ifstream ifile(filename.c_str(), std::ios::binary);
	if (!ifile.fail())	{

		// ----- read the DOS header
		IMAGE_DOS_HEADER dosheader;
		ifile.read((char*)&dosheader, sizeof dosheader);

		// ----- test .exe file signature
		if (dosheader.e_magic == IMAGE_DOS_SIGNATURE)	{
			// --- is an executable

			// ----- read offset to portable executable header
			ifile.seekg(dosheader.e_lfanew);
			// ---- read the pertable executable header
			struct {
				long signature;
				IMAGE_FILE_HEADER fhdr;
				IMAGE_OPTIONAL_HEADER ohdr;
			} header;

			ifile.read((char*)&header, sizeof header);
			// ----  check the signature
			if (header.signature == IMAGE_NT_SIGNATURE)	{
				// --- is a portable exe file

				// ----- iterate through the segments looking for .stab
				for (int i = 0; i < header.fhdr.NumberOfSections; i++)	{
					IMAGE_SECTION_HEADER secthdr;
					ifile.read((char*)&secthdr, sizeof(secthdr));
					char name[9];
					strncpy(name, (char*)secthdr.Name, 8);
					name[8] = '\0';

					if (strcmp(name, ".stab") == 0)	{
						hasstabs = true;
						break;
					}
				}
			}
		}
	}
}


