// --- executor.h
#ifndef EXECUTOR_H
#define EXECUTOR_H

#include "quincy.h"

class Executor	{
	PROCESS_INFORMATION pinfo;
	std::string Exename;
	std::string Args;
	bool running;
	bool successfulrun;
	DWORD exitcode;
	HANDLE m_hStdin;
	HANDLE m_hStdout;
	HANDLE m_hStderr;

	static Executor* executor;
	static UINT DoRun(void*);
	void runapplication();
	void closehandle(HANDLE& handle);
	HANDLE BuildStdout(const CString& rstrPath, bool append);
	HANDLE BuildStdin(const CString& rstrPath);
	HANDLE BuildStderr(const CString& rstrPath);
	HANDLE BuildStderr();
	void CloseConsoleHandle(HANDLE& hStd, DWORD stdhandle);
	void CloseConsoleHandles();
	void shutdown();
public:
	Executor(const char* exename);
	virtual ~Executor();
	void Run(const char* params);
	bool IsRunning() const { return running; }
	bool SuccessfulRun() const { return successfulrun; }
	DWORD Exitcode() const { return exitcode; }
};

#endif
