// Quincy.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include <shlobj.h>
#include <algorithm>
#include <process.h>
#include <ddeml.h>
#include <io.h>
#include "Quincy.h"
#include "AboutDlg.h"
#include "MainFrm.h"
#include "ChildFrm.h"
#include "QuincyDoc.h"
#include "QuincyView.h"
#include "TextDocument.h"
#include "TextView.h"
#include "stabs.h"

#include "OptionsSheet.h"
#include "BuildDialog.h"
#include "RunOptions.h"
#include "EditorOptions.h"
#include "LinkDialog.h"
#include "QuincyPrintDialog.h"

#include "CommandLineDialog.h"
#include "ErrorLogDialog.h"
#include "ExamineDialog.h"
#include "WatchDialog.h"
#include "debugger.h"
//#include "TutDlg.h"
#include "compiler.h"
#include "grep.h"
#include "executor.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CQuincyApp

BEGIN_MESSAGE_MAP(CQuincyApp, CWinApp)
	//{{AFX_MSG_MAP(CQuincyApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_STOPBUILD, OnStop)
	ON_UPDATE_COMMAND_UI(ID_STOPBUILD, OnUpdateStop)
	ON_COMMAND(ID_OPTIONS, OnOptions)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_CLEARBREAKPOINTS, OnUpdateDebugClearbreakpoints)
	ON_COMMAND(ID_DEBUG_CLEARBREAKPOINTS, OnDebugClearbreakpoints)
	ON_COMMAND(ID_DEBUG_STEPOVER, OnDebugStepover)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_EXAMINE, OnUpdateDebugExamine)
	ON_COMMAND(ID_DEBUG_EXAMINE, OnDebugExamine)
	ON_COMMAND(ID_DEBUG_WATCH, OnDebugWatch)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPOVER, OnUpdateDebugStepover)
	ON_COMMAND(ID_HELP, OnHelp)
	ON_COMMAND(ID_HELP_PROGRAMMER, OnProgrammerHelp)
	ON_COMMAND(ID_TYCPP, OnTycpp)
	ON_COMMAND(ID_RESOURCEEDITOR, OnResourceeditor)
	ON_COMMAND(ID_TOOLS_FLUID, OnToolsFluid)
	ON_COMMAND(ID_TOOLS_COMMANDPROMPT, OnToolsCommandPrompt)
	ON_COMMAND(ID_GREP, OnGrep)
	ON_UPDATE_COMMAND_UI(ID_GREP, OnUpdateGrep)
	ON_UPDATE_COMMAND_UI(ID_RESOURCEEDITOR, OnUpdateResourceeditor)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_FLUID, OnUpdateToolsFluid)
	ON_UPDATE_COMMAND_UI(ID_TOOLS_COMMANDPROMPT, OnUpdateToolsCommandPrompt)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_VIEW_GDBCONSOLE, OnViewGdbconsole)
	ON_UPDATE_COMMAND_UI(ID_HELP, OnUpdateHelp)
	ON_UPDATE_COMMAND_UI(ID_HELP_PROGRAMMER, OnUpdateProgrammerHelp)
	ON_UPDATE_COMMAND_UI(ID_TYCPP, OnUpdateTycpp)
	ON_UPDATE_COMMAND_UI(ID_PROPERTIES, OnUpdateProperties)
	ON_COMMAND(ID_PROPERTIES, OnProperties)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_PRINT_SETUP, OnFilePrintSetup)
/* No tutorials
#ifdef TYCPP
	// Tutorial commands
	ON_COMMAND(ID_WRITETUTORIAL, OnWritetutorial)

	ON_COMMAND(ID_TYCPP, OnTycpp)
	ON_UPDATE_COMMAND_UI(ID_TYCPP, OnUpdateTycpp)
#endif
*/

END_MESSAGE_MAP()

static const int maxsaveddocuments = 10;	// maximum # of documents remembered when reloading

//////////////////////////////////////////////////////////////
// Static service functions

/*
 * Shortens a path to the short 8.3 DOS version required by MingW
 */
CString shortDosPath(CString longWindowsPath)
{
	DWORD len = longWindowsPath.GetLength(), required_len;
	char *buffer = (char *)malloc(len + 1);
	required_len = GetShortPathName((LPCSTR)longWindowsPath, buffer, len + 1);

	// If GetShortPath() failed for some reason return long path
	if(!required_len)
	{
		free(buffer);
		return longWindowsPath;
	}
	else if(required_len > len + 1) // Buffer was too short
	{
		free(buffer);
		buffer = (char *)malloc(required_len + 1);
		GetShortPathName((LPCSTR)longWindowsPath, buffer, required_len + 1);
	}

    CString shortPath = buffer;
	free(buffer);
	return shortPath;
}


/* Recursively searches for a "subdirName" subdirectory below startPath
 * Param startPath should end with a '\'
 * Returns the subdir path if found, or the startpath if not.
 */
static CString getPathTo(CString & startPath, CString & subdirName)
{
	struct _finddata_t file;
	long hFile;
	CString strSpec = startPath + subdirName;

	// If subdirName is a subdir of startPath return its path
	if ((hFile = _findfirst(strSpec.GetBuffer(0), &file)) != -1L
			&& (file.attrib & _A_SUBDIR) != 0)
	{
		_findclose(hFile);
		return strSpec + '\\';
	}
		
	// Else recursively call getPathTo on all subdirs until found or not exists
	_findclose(hFile);
	strSpec = startPath + "*.*";
	int foundFile = hFile = _findfirst(strSpec.GetBuffer(0), &file);

	while(foundFile != -1L)
	{
		CString ret;
		CString newPath = startPath + file.name + '\\';

		if ((file.attrib & _A_SUBDIR) != 0 && *file.name != '.'  ) 
			// It's a directory
		{
			ret = getPathTo(startPath + file.name + '\\', subdirName);
			// If getPathTo() has found the subdir, return the path
			if (ret != newPath)
			{
				_findclose(hFile);
				return ret;
			}
		}
		// else, keep looking
		foundFile = _findnext(hFile, &file);
		
	} // end while

	// If here, then it does not exist
	_findclose(hFile);
	return startPath;
}

/////////////////////////////////////////////////////////////////////////////
// CQuincyApp construction

CQuincyApp::CQuincyApp()
{
	setlocale(LC_ALL, ""); // Allow all foreign characters to be entered
	m_pEditorView = 0;
	m_pCompiler = 0;
	m_pGrep = 0;
	m_pExecutor = 0;
	m_bPrintLineNos = false;
	m_bCpp = false;
	m_bDoLink = false;
	m_pView = 0;
	m_bDebugging = false;
	m_bExceptions = false;
	m_bRTTI = false;
	m_bStrict = true;
	m_bC99 = true;
	m_bWarnType = 0;
	m_bBrowser = false;
	m_maxundos = 1024;
	m_style = 0;
	m_nOptimize = 0;
	m_nExitCode = 0;
	m_pdlgWatch = new CWatchDialog;
	m_pdlgExamine = new CExamineDialog;
	m_pdlgGdbConsole = new GdbConsole;
	m_bBypassChangeTest = false;
	m_CommandLinePromptOption = 0;
	m_pDebugger = 0;
	m_ConsoleRect.SetRectEmpty();
	stepping = false;
/* No tutorial
#ifdef TYCPP
	m_bReadTutorial = false;
	m_bTutorialDisplayed = false;
	m_bIsTutorial = false;
	m_pCTutDlg = 0;
	m_bTutCreated = false;
#endif
*/
	m_bGrepIsInstalled = false;
	m_bAStyleIsInstalled = false;
	m_bWEditResIsInstalled = false;
	m_bCompilerIsInstalled = false;
	m_bWatchCreated = false;
	m_bGdbConsoleCreated = false;

	m_bSyntaxColors = false;
	m_backgroundcolor = RGB(255,255,255);
	m_normalcolor     = RGB(0,0,0);
	m_keywordcolor    = RGB(0,0,255);
	m_commentcolor    = RGB(0,128,0);
	m_stringcolor     = RGB(255,0,0);
	m_defaultfontheight = 13;
	m_defaultfontwidth = 8;
	m_fontheight = m_defaultfontheight;
	m_fontwidth  = m_defaultfontwidth;
	m_fontheight = FW_NORMAL;
//	m_fontface = "Courier";
}

CQuincyApp::~CQuincyApp()
{
	delete m_pdlgWatch;
	delete m_pdlgExamine;
	delete m_pDebugger;
	delete m_pdlgGdbConsole;
/* No tutorial since Quincy 2005 v1.1
#ifdef TYCPP
	delete m_pCTutDlg;
#endif
*/
	delete m_pCompiler;
	delete m_pGrep;
	delete m_pExecutor;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CQuincyApp object

CQuincyApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CQuincyApp initialization

// Add a static BOOL that indicates whether the class was
// registered so that we can unregister it in ExitInstance
static BOOL bClassRegistered = FALSE;

BOOL CQuincyApp::InitInstance()
{
	// If a previous instance of the application is already running,
	// then activate it and return FALSE from InitInstance to
	// end the execution of this instance.

	if(!FirstInstance())
		return FALSE;

	// Register our unique class name that we wish to use
	WNDCLASS wndcls;

	memset(&wndcls, 0, sizeof(WNDCLASS));   // start with NULL
										  // defaults

	wndcls.style = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wndcls.lpfnWndProc = ::DefWindowProc;
	wndcls.hInstance = AfxGetInstanceHandle();
	wndcls.hIcon = LoadIcon(IDR_MAINFRAME); // or load a different
										  // icon
	wndcls.hCursor = LoadCursor( IDC_ARROW );
	wndcls.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wndcls.lpszMenuName = NULL;

	// Specify our own class name for using FindWindow later
	wndcls.lpszClassName = _T("QuincyAppClass");

	// Register new class and exit if it fails
	if(!AfxRegisterClass(&wndcls))
	{
		TRACE("Class Registration Failed\n");
		return FALSE;
	}
	bClassRegistered = TRUE;


/////////////////////////////////////////////////////////
	SetRegistryKey("Al Stevens Programs");

    osversion.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osversion);

	// --- need some paths for looking for compilers, tutorials, tools
		
	// This does not work for Quincy portable. use __argv[0] instead
	/*m_strQuincyBinPath = m_pszHelpFilePath;
	int nIndex = m_strQuincyBinPath.ReverseFind('\\');
	ASSERT(nIndex > 0);
	m_strQuincyBinPath = m_strQuincyBinPath.Left(nIndex);*/

	m_strQuincyBinPath = __argv[0];
	int nIndex = m_strQuincyBinPath.ReverseFind('\\');
	ASSERT (nIndex > 0);
	m_strQuincyBinPath = m_strQuincyBinPath.Left( nIndex );

/* Deprecated in .NET 2003
#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif
*/
	LoadStdProfileSettings(10);  // Load standard INI file options 
								 // show up to 10 MRU files

	// ---- load Quincy's INI options
	m_bAutoindent = GetProfileInt("Options", "AutoIndent", 1);
	m_taboption   = GetProfileInt("Options", "Tabs", 0);
	m_bSyntaxColors = GetProfileInt("Options", "Syntax Colors", 1);
	m_tabstops = GetProfileInt("Options", "Tab Stops", 4);
	m_maxundos = GetProfileInt("Options", "Max Undos", 1024);

	m_strCompiler    = GetProfileString("Directories", "Compiler");
	m_strDebugger    = GetProfileString("Directories", "Debugger");
	m_strRuntimeDirectory = GetProfileString("Directories", "Runtime");
	m_bPrintLineNos = GetProfileInt("Options", "Print Line Numbers", 0) != 0;

	m_backgroundcolor = GetProfileInt("Options", "Background Color",  RGB(255,255,255));
	m_normalcolor     = GetProfileInt("Options", "Normal Color",      RGB(0,0,0));
	m_keywordcolor    = GetProfileInt("Options", "Keyword Color",     RGB(0,0,255));
	m_commentcolor    = GetProfileInt("Options", "Comment Color",     RGB(0,128,0));
	m_stringcolor     = GetProfileInt("Options", "String Color",      RGB(255,0,0));

	m_fontheight = GetProfileInt("Options",    "Font Height", 13);
	m_fontwidth  = GetProfileInt("Options",    "Font Width",  8);
	m_fontweight = GetProfileInt("Options",    "Font Weight", FW_NORMAL);
//	m_fontface   = GetProfileString("Options", "Font Face", "Courier");

	m_style           = GetProfileInt("Options", "Style", 0); 
	m_command		  = GetProfileString("Options", "Command");

/* No Tutorial
#ifdef TYCPP
	m_bTutorialDisplayed = GetProfileInt("Tutorial",    "Displayed", 1);
#endif
*/
	m_bDebugging = GetProfileInt("Options", "Debugging", 1);
	m_bExceptions = GetProfileInt("Options", "Exceptions", 0);
	m_bRTTI = GetProfileInt("Options", "RTTI", 0);
	m_bStrict = GetProfileInt("Options", "Strict", 1);
	m_bC99 = GetProfileInt("Options", "C99", 0);
	m_bWarnType = GetProfileInt("Options", "WarnType", 0);
	m_strCommandLine = GetProfileString("Options", "Command Line");
	m_strCmdLineOptions = GetProfileString("Options", "Compiler Command Line Options");
	m_strLinkerOptions = GetProfileString("Options", "Linker Command Line Options");
	m_CommandLinePromptOption = GetProfileInt("Options", "Command Line Prompt", 0);
	m_nOptimize = GetProfileInt("Options", "Optimize", 0);
	CString strBuffer = GetProfileString("Settings", "Console Position");
	if (!strBuffer.IsEmpty())
		_stscanf (strBuffer, "%i:%i:%i:%i",
			&m_ConsoleRect.left,
			&m_ConsoleRect.top,
			&m_ConsoleRect.right,
			&m_ConsoleRect.bottom);

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;

	pDocTemplate = new CMultiDocTemplate(
		IDR_CPPTEMPLATE,
		RUNTIME_CLASS(CTextDocument),	// document class
		RUNTIME_CLASS(CChildFrame),		// frame class
		RUNTIME_CLASS(CTextView));		// view class
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_CTEMPLATE,
		RUNTIME_CLASS(CTextDocument),	// document class
		RUNTIME_CLASS(CChildFrame),		// frame class
		RUNTIME_CLASS(CTextView));		// view class
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_HTEMPLATE,
		RUNTIME_CLASS(CTextDocument),	// document class
		RUNTIME_CLASS(CChildFrame),		// frame class
		RUNTIME_CLASS(CTextView));		// view class
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_PROJTYPE,
		RUNTIME_CLASS(CQuincyDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CQuincyView));
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_RCTEMPLATE,
		RUNTIME_CLASS(CTextDocument),	// document class
		RUNTIME_CLASS(CChildFrame),		// frame class
		RUNTIME_CLASS(CTextView));		// view class
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_DEFTEMPLATE,
		RUNTIME_CLASS(CTextDocument),	// document class
		RUNTIME_CLASS(CChildFrame),		// frame class
		RUNTIME_CLASS(CTextView));		// view class
	AddDocTemplate(pDocTemplate);

	pDocTemplate = new CMultiDocTemplate(
		IDR_EDITORTYPE,
		RUNTIME_CLASS(CTextDocument),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CTextView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	m_pMainWnd = pMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return false;

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	CWnd* pFocusWnd = 0;

	// Enable DDE Execute open
	EnableShellOpen();

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// ------- find path to TEMP disk space if any
	char* tempenv;
	if ((tempenv = getenv("TEMP")) != 0)	{
		m_strTempPath = tempenv;
		if (m_strTempPath.GetLength() && m_strTempPath[m_strTempPath.GetLength()-1] != '\\')
			m_strTempPath += "\\";
	}

	SetCompilerPaths();
//	TestDebuggerPath();

	SetBrowserPath();

/* No tutorial
#ifdef TYCPP
	LoadTutorials();
	int nDocno = 0;

	bool bCmdFile = false;

	// --- suppress initial FileNew command on startup
	if (cmdInfo.m_nShellCommand != CCommandLineInfo::FileNew)	{
		if (cmdInfo.m_strFileName != "tutorial")
		{
			if (IsTutorial(cmdInfo.m_strFileName))
			{
				// --- reading a .tut file
				m_bReadTutorial = true;
				int nIndex = cmdInfo.m_strFileName.ReverseFind('\\');
				if (nIndex == -1)	{
					char path[MAX_PATH];
					getcwd(path, MAX_PATH);
					m_strTutorial = path;
					m_strTutorial += "\\";
				}
				m_strTutorial += cmdInfo.m_strFileName;
			}
			else if (!ProcessShellCommand(cmdInfo))
				return false;
			else
			{
				// ---- loading file from command line
				bCmdFile = true;
				CString strPath = GetFilePath(cmdInfo.m_strFileName);
				if (!strPath.IsEmpty())
					_chdir(strPath);
			}
		}
	}

	else if (!m_bIsTutorial || !m_bTutorialDisplayed)	{
		// ----- reload documents from the previous session
		CString strProfile;
		for (; nDocno < maxsaveddocuments; nDocno++)	{
			strProfile.Format("Document%d", nDocno+1);
			CString strDocument = GetProfileString("Documents", strProfile, 0);
			if (strDocument.IsEmpty())
				break;

			if (OpenDocumentFile(strDocument))	{
				// --- if the document was maximized on exit, maximize it now
				strProfile.Format("Document%d Maximized", nDocno+1);
				bool bIsMax = GetProfileInt("Documents", strProfile, 0);
				if (bIsMax)
					// --- by coincidence, GetTextView works for project document, too
					pFocusWnd = MaximizeDocument(strDocument);
			}
		}
	}

	if (!bCmdFile)	{
		// ---- reload tutorial info from the previous session
		m_strTutorial = GetProfileString("Tutorial", "Current", 0);
		// ---- reload working directory from the previous session
		CString strPath = GetProfileString("Directories", "Current", 0);
		// ------ change to current working directory
		if (!strPath.IsEmpty())
			_chdir(strPath);
	}
#else
*/
	int nDocno = 0;

	bool bCmdFile = false;

	// --- suppress initial FileNew command on startup
	if (cmdInfo.m_nShellCommand != CCommandLineInfo::FileNew)	{
		if (!ProcessShellCommand(cmdInfo))
			return false;
		// ---- loading file from command line
		bCmdFile = true;
		CString strPath = GetFilePath(cmdInfo.m_strFileName);
		if (!strPath.IsEmpty())
			_chdir(strPath);
	}
	else	{
		// ----- reload documents from the previous session
		CString strProfile;
		for (; nDocno < maxsaveddocuments; nDocno++)	{
			strProfile.Format("Document%d", nDocno+1);
			CString strDocument = GetProfileString("Documents", strProfile, 0);
			if (strDocument.IsEmpty())
				break;

			if (OpenDocumentFile(strDocument))	{
				// --- if the document was maximized on exit, maximize it now
				strProfile.Format("Document%d Maximized", nDocno+1);
				bool bIsMax = GetProfileInt("Documents", strProfile, 0);
				if (bIsMax)
					// --- by coincidence, GetTextView works for project document, too
					pFocusWnd = MaximizeDocument(strDocument);
			}
		}
	}

	if (!bCmdFile)	{
		// ---- reload working directory from the previous session
		CString strPath = GetProfileString("Directories", "Current", 0);
		// ------ change to current working directory
		if (!strPath.IsEmpty())
			_chdir(strPath);
	}

// #endif

	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	if (pFocusWnd != 0)
		pFocusWnd->SetFocus();

/* No tutorial
#ifdef TYCPP

	if (!bCmdFile && m_bIsTutorial && nDocno == 0 && m_bTutorialDisplayed)	{
		OnTycpp();
		ASSERT(m_pCTutDlg != 0);
		m_pCTutDlg->LoadSelectedTutorial();
	}
	// --- disable tycpp command if tutorial not present
	if (!m_bIsTutorial)
		((CMainFrame*)pMainFrame)->HideTYCPPCommand();
#endif
*/
	return true;
}

void CQuincyApp::SetBrowserPath()
{
	char path[MAX_PATH];
	m_bBrowser = (reinterpret_cast<int>(FindExecutable((m_strQuincyInstallPath + 
		          "\\programmerGuide.htm").GetBuffer(0), 0, path))) > 32;
}
/*
void CQuincyApp::TestDebuggerPath()
{
	if (m_strDebugger.IsEmpty())	{
		m_strDebugger = m_strQuincyInstallPath + "\\gdb\\";
		for (int i = 0; i < 2; i++)	
			if (_access(m_strDebugger + "gdb.exe", 0) != 0)
				m_strDebugger = m_strToolsPath;
	}
	if (_access(m_strDebugger + "gdb.exe", 0) != 0)
		AfxMessageBox(	"No Debugger found. Install gdb.exe "
			"and set the debugger's installation path in the "
			"Tools/Options dialog's Build tab.", MB_ICONSTOP);
}
*/

/**
 * Set compiler and tools paths and environment variables 
 */
void CQuincyApp::SetCompilerPaths()
{
	delete m_pCompiler;
	m_pCompiler = 0;

	// ---- set paths to find the compiler executables
	int nIndex = m_strQuincyBinPath.ReverseFind('\\');
	ASSERT(nIndex > 0);
	m_strQuincyInstallPath = m_strQuincyBinPath.Left(nIndex);

	// poor man's constructor

	m_bCompilerIsInstalled = false;

	m_strToolsPath.Empty();
	m_strIncludePath.Empty();
	m_strRIncludePath.Empty();
	m_strStartupCode.Empty();
	m_strLibPath.Empty();
	m_strVersion.Empty();

	m_strLCCPath = m_strQuincyInstallPath + "\\lcc\\bin\\";
	// Set paths to extra libraries include and lib directories
	m_strXIncludePath = m_strQuincyInstallPath + "\\include";
	m_strXLibPath = m_strQuincyInstallPath + "\\lib";

	for (;;)	{

		// loops in case Quincy expects compiler on cd-rom and cd is not in drive
		// only comes back here if programmed compiler path cd and can't find compiler
		// and user does not Cancel the retry

		CString strCompilerBin;
		CString strMingw32LibDir = "mingw32";
		CString strCompiler;

		// looking for the mingw32 compiler
		//
		//	This code depends on gcc-Mingw32 compiler's subdirectory structure
		//  If they change it, this code will need to be changed.
		//
		// start from the programmed compiler location
		strCompiler = m_strCompiler;
		if (strCompiler.IsEmpty())
			// no programmed location, look for mingw off the quincy install directory
			strCompiler = m_strQuincyInstallPath + "\\mingw\\";

		// Search for the mingw32 subdir below lib
		// --- scanning for one of the mingw32 compilers
		CString CompilerPath = getPathTo(strCompiler + "lib\\", strMingw32LibDir); 
		// --- path should now be mingw32, i386-mingw32, or i386-mingw32msvc, I hope
	
		CString strSpec = CompilerPath + "*.*";
		struct _finddata_t file;
		long hFile;
		
		// --- gcc-mingw32 uses its version number as the only subdirectory
		//     under the "lib\\gcc-lib\\mingw32\\"
		//     (Since 3.4, really under "lib\\....\\mingw32\\")
		//     By scanning for it, don't need a Quincy recompile 
		//     whenever they release a new version (I hope)

		/* Correction: Since gcc 3.4.x the mingw32 subdirecty is
		 * "lib\\gcc\\mingw32". Just to make things interesting, I guess. So 
		 * this code now searches for any "lib\\.....\\mingw32" directory, 
		 * assuming that it will be the correct one
		 */
		if ((hFile = _findfirst(strSpec.GetBuffer(0), &file)) != -1)	{
			while (*file.name == '.' || (file.attrib & _A_SUBDIR) == 0)
				if (_findnext(hFile, &file) != 0)
					break;
			if (*file.name != '.' && (file.attrib & _A_SUBDIR) != 0)
				m_strVersion = file.name;
			_findclose(hFile);
		}
		if (!m_strVersion.IsEmpty())	{
			// ---- found a version of mingw32
			strCompilerBin = strCompiler + "bin\\";
			// Convert ToolPath to short DOS path version for MingW tools
			m_strToolsPath = shortDosPath(strCompilerBin);

			m_strIncludePath = strCompiler + "include\\";

			// --- make sure that at least gcc is in the directory
			CString strGcc = m_strToolsPath + "gcc.exe";
			m_bCompilerIsInstalled = _access(strGcc, 0) == 0;

			if (m_bCompilerIsInstalled)	{
				m_strCompiler = strCompiler;	// update the programmed compiler path
				m_pCompiler = new GCCCompiler();
			}
		}

		// --- set flags to disable compiler and tools menu items if executables are not installed
		CMenu* pMenu = ((CMainFrame*)m_pMainWnd)->GetMenu();
		ASSERT(pMenu != 0);

		CString strGrep = m_strQuincyBinPath + "\\grep.exe";
		m_bGrepIsInstalled = _access(strGrep, 0) == 0;

		CString strAStyle = m_strQuincyBinPath + "\\astyle.exe";
		m_bAStyleIsInstalled = _access(strAStyle, 0) == 0;

		CString strWEditRes(m_strLCCPath + "weditres.exe ");
		m_bWEditResIsInstalled = _access(strWEditRes, 0) == 0;

		// Check if Fluid is installed, if it is, setup help path
		CString strFluid = m_strQuincyBinPath + "\\fluid.exe";
		m_bFluidIsInstalled = _access(strFluid, 0) == 0;
		if(m_bFluidIsInstalled)
		{
			CString fltk_docdir("FLTK_DOCDIR=" + ProgrammerHelpPath() + "fltk\\fltk1.1\\");
			_putenv(fltk_docdir.GetBuffer(0));
		}

		if (!m_bCompilerIsInstalled)	{
			if (IsOnCDROM(m_strToolsPath))	{
				CString msg("Compiler files not found. Insert CD-ROM in ");
				char dr[3] = "x:";
				*dr = m_strToolsPath[0];
				msg += dr;
				if (AfxMessageBox(msg, MB_RETRYCANCEL) == IDRETRY)
					continue;	// start all over again at the for (;;) loop
			}
			else	{
				AfxMessageBox(	"Install MinGW "
					"and set the compiler's installation path in the "
					"Tools/Options dialog's Build tab.", MB_ICONSTOP);
			}
		}
		else	{
			// --- set path so compiler can find its own tools
			char* penv = 0;
			penv = getenv("PATH");
			//If Vista, search for compatible applications in vistabin directory
			CString quincyBin;
			if ((osversion.dwPlatformId == VER_PLATFORM_WIN32_NT)
				&& ( osversion.dwMajorVersion == 6 ))
			{
				quincyBin = m_strQuincyBinPath + "\\VistaBin;";
			}
			// Standard path for other OSs
			quincyBin += m_strQuincyBinPath;

			CString path("Path=" + strCompilerBin + ";"
								 + quincyBin + ";" + penv);
			//CString path("Path=" + m_strToolsPath + ";" + penv); // short path for Win98
			_putenv(path.GetBuffer(0));
			// --- program debugger path if one is not already programmed
			// TestDebuggerPath();
			m_strDebugger = m_strToolsPath;
			// Unset environment variable GCC_EXEC_PREFIX that could have been 
			// set by a legacy application using egcs (e.g. PSCAD)
			_putenv("GCC_EXEC_PREFIX=");
		}
		break;
	}
}

CWnd* CQuincyApp::MaximizeDocument(const CString& strDocument)
{
	CTextView* pView = GetTextView(strDocument);
	ASSERT(pView != 0);
	CWnd* pWnd = pView->GetParent();
	ASSERT(pWnd != 0);
	WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
	if (pWnd->GetWindowPlacement(&wndpl))	{
		wndpl.showCmd = SW_SHOWMAXIMIZED;
		pWnd->SetWindowPlacement(&wndpl);
	}
	return pView;
}

CDocument* CQuincyApp::OpenDocumentFile(LPCTSTR lpszFileName) 
{
	CString strDocument(lpszFileName);

	// Get round assert if path was on moveable media and gone.
	CFileStatus status;
	if ( ! CFile::GetStatus( strDocument, status ))
		return NULL;

	if (strDocument.Right(4).CompareNoCase(".prj") == 0)	{
		// ----- change to the subdirectory where project file is located
		int offset = strDocument.ReverseFind('\\');
		if (offset != -1)	{
			CString strPath = strDocument.Left(offset);
			_chdir(strPath);
		}
	}
	return CWinApp::OpenDocumentFile(lpszFileName);
}

void CQuincyApp::ChangeToRuntimeDirectory(CString& strCmd)
{
	// --- determine where the target program should write its file output (if any)
	// --- if a project, see if the project has a working directory programmed
	CString strWk = GetProjectRuntimeDirectory();
	if (strWk.IsEmpty())	{
		// either not a project or no working directory programmed
		// see if the options have a working directory programmed
		strWk = GetRuntimeDirectory();
		if (strWk.IsEmpty())	{
			// no options working directory programmed
			if (IsOnCDROM(strCmd))
				// use the TEMP directory, if TEMP is set. (If not, you're on your own)
				strWk = GetTemporaryDirectory();
			else	{
				// ----- change to the subdirectory where 
				//       executable file is located
				int offset = strCmd.ReverseFind('\\');
				if (offset != -1)	{
					strWk = strCmd.Left(offset);
				}
			}
		}
	}
	if (!strWk.IsEmpty())
		_chdir(strWk);
}

void CQuincyApp::StartProgram(CString& strCmd)
{
	// make true if any breakpoints are programmed.
	bool breakpointsset = breakpoints.size() > 0 || !steptobreakpoint.m_strFile.IsEmpty();

//	CString strCmd = Enquote(cmd);
	ChangeToRuntimeDirectory(strCmd);
	CStab stabs(strCmd.GetBuffer(0));
	if (stabs.TestStabs() && breakpointsset)
		DebugProgram(strCmd);
	else	{
		CString strCmdline;
		GetCommandLine(strCmdline);

		delete m_pExecutor;
		m_pExecutor = new Executor(strCmd);
		m_pExecutor->Run(strCmdline.GetBuffer(0));
	}
}

void CQuincyApp::DebugProgram(CString strCmd, bool bStepping)
{
//	CString strCmd = Enquote(cmd);
	CStab stabs(strCmd.GetBuffer(0));
	if (stabs.TestStabs())	{
		ChangeToRuntimeDirectory(strCmd);

		ASSERT(m_pDebugger == 0);
		m_pDebugger = new Debugger;

		CString strCmdline;
		GetCommandLine(strCmdline);
		if (!strCmdline.IsEmpty())	{
			strCmd += " ";
			strCmd += strCmdline;
		}
		m_pDebugger->LoadDebugger(strCmd.GetBuffer(0));
		PostWatchList();
		std::set<Breakpoint>::iterator iter;
		for (iter=breakpoints.begin(); iter != breakpoints.end(); iter++)
			m_pDebugger->SetBreakpoint(*iter);

		if (bStepping)
			m_pDebugger->StepIntoProgram();
		else
			m_pDebugger->StartProgram();
	}
	else if (AfxMessageBox("No debug information. Run anyway?", MB_YESNO | MB_ICONQUESTION) == IDYES)
		StartProgram(strCmd);
}

// --- called from the debugger to stop itself. Don't call this from anywhere else
void CQuincyApp::StopDebugger()
{
	delete m_pDebugger;
	m_pDebugger = 0;
}

void CQuincyApp::GetCommandLine(CString& strCmdLine)
{
	if (m_CommandLinePromptOption == 0)
		strCmdLine = "";
	else	{
		strCmdLine = m_strCommandLine;
		if (m_CommandLinePromptOption == 1)	{
			CCommandLineDialog dlgCmdLine;
			if (dlgCmdLine.DoModal() == IDOK)
				strCmdLine = dlgCmdLine.m_strCommandLine;
		}
	}
}

// ----  extract the path from a file specification
CString CQuincyApp::GetFilePath(const CString& rstrPath)
{
	int offset = rstrPath.ReverseFind('\\');
	if (offset == -1)
		offset = rstrPath.ReverseFind('/');
	return offset == -1 ? CString() : rstrPath.Left(offset);
}
// ----  extract the filename from a file specification
CString CQuincyApp::GetFileName(const CString& rstrPath)
{
	int offset = rstrPath.ReverseFind('\\');
	if (offset == -1)
		offset = rstrPath.ReverseFind('/');
	return offset == -1 ? rstrPath : rstrPath.Right(rstrPath.GetLength() - offset - 1);
}

// ----- compare the date/time stamps on two files
// @return -tive if strFile1 is older, +tive if strFile2 is older, 0 if same date
int CQuincyApp::CompareFileTimes(CString& strFile1, CString& strFile2)
{
	struct _stat buf1;
	char* path1 = strFile1.GetBuffer(0);
	int rtn1 = _stat(path1, &buf1);

	struct _stat buf2;
	char* path2 = strFile2.GetBuffer(0);
	int rtn2 = _stat(path2, &buf2);

	// --- a non-existing file is always older than one that exists
	if (rtn1 == -1 && rtn2 == -1)
		return 0;
	if (rtn1 == 0 && rtn2 == -1)
		return 1;
	if (rtn1 == -1 && rtn2 == 0)
		return -1;

	// ---- a zero-length file is always older than one with data
	if (buf1.st_size == 0 && buf2.st_size != 0)
		return -1;
	if (buf1.st_size != 0 && buf2.st_size == 0)
		return 1;

	return buf1.st_mtime - buf2.st_mtime;
}

CString CQuincyApp::GetProjectRuntimeDirectory()
{
	CString strWk;
	CQuincyDoc* pDoc = CQuincyDoc::CurrentProject();
	if (pDoc != 0)
		strWk = pDoc->WorkingDirectory();
	return strWk;
}

CString CQuincyApp::GetProjectPath()
{
	CString strProj;
	CQuincyDoc* pDoc = CQuincyDoc::CurrentProject();
	if (pDoc != 0)	
		return pDoc->ProjectPath();
	return "";
}

CQuincyDoc* CQuincyApp::GetProjectDocument(CString* pstrPath)
{
	CQuincyDoc* pDoc = CQuincyDoc::CurrentProject();
	if (pDoc != 0)	{
		CString strPath = pDoc->GetPathName();
		if (pstrPath != 0)
			*pstrPath = strPath;
	}
	return pDoc;
}

bool CQuincyApp::IsLibraryTarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsLibraryTarget();
	return false;
}

bool CQuincyApp::IsGUITarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsGUITarget();
	return false;
}
bool CQuincyApp::IsFLTKTarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsFLTKTarget();
	return false;
}
bool CQuincyApp::IsWithConsole()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsWithConsole();
	return true; // if no project, then there must be a console.
}

bool CQuincyApp::IsFLTK_Forms()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsFLTK_Forms();
	return false; // if no project, then no FLTK library.
}

bool CQuincyApp::IsFLTK_OpenGL()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsFLTK_OpenGL();
	return false; // if no project, then no FLTK library.
}
bool CQuincyApp::IsFLTK_Images()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsFLTK_Images();
	return false; // if no project, then no FLTK library.
}
bool CQuincyApp::IsBGITarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsBGITarget();
	return false;
}

bool CQuincyApp::IsKoolplotTarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsKoolplotTarget();
	return false;
}

bool CQuincyApp::IsDLLTarget()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsDLLTarget();
	return false;
}

bool CQuincyApp::IsConsoleApplication()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		return pDoc->IsConsoleApplication();
	return true; // If no project, then it's a console job.
}

void CQuincyApp::ParseFileSpec(CString& strFileSpec, CString& strCmdLine, int nIndex)
{
	int ndx = nIndex + 1;
	CString cmdLine(strCmdLine.Left(nIndex) + " ");

	strFileSpec.Empty();

	while (isspace(strCmdLine[ndx]))
		ndx++;
	while (ndx < strCmdLine.GetLength() && !isspace(strCmdLine[ndx]) 
				&& strCmdLine[ndx] != '<' && strCmdLine[ndx] != '>')
		strFileSpec += strCmdLine[ndx++];

	while (++ndx < strCmdLine.GetLength())
		cmdLine += strCmdLine[ndx];
	
	strCmdLine = cmdLine;
}

CQuincyView* CQuincyApp::GetProjectView()
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)	{
		POSITION vpos = pDoc->GetFirstViewPosition();
		ASSERT(vpos != 0);
		CQuincyView* pView = static_cast<CQuincyView*>(pDoc->GetNextView(vpos));
		ASSERT(pView != 0);
		return pView;
	}
	return 0;
}

CTextDocument* CQuincyApp::GetTextDocument(CString pstrPath)
{
	POSITION tpos = GetFirstDocTemplatePosition();
	CString strArgFile = GetFileName(pstrPath);
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CTextDocument* pDoc = static_cast<CTextDocument*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			CString strDocFile = GetFileName(pDoc->GetPathName());
			if (strArgFile.CompareNoCase(strDocFile) == 0)
				return pDoc;
		}
	}
	return 0;
}

CTextView* CQuincyApp::GetTextView(CString pstrPath)
{
	CTextDocument* pDoc = GetTextDocument(pstrPath);
	if (pDoc != 0)	{
		POSITION vpos = pDoc->GetFirstViewPosition();
		ASSERT(vpos != 0);
		CTextView* pView = static_cast<CTextView*>(pDoc->GetNextView(vpos));
		ASSERT(pView != 0);
		return pView;
	}
	return 0;
}

void CQuincyApp::RunResourceEditor(const CString& strItem)
{
	CString strCmd(m_strLCCPath + "weditres.exe " + strItem);
	STARTUPINFO suinfo = { sizeof(STARTUPINFO) };
	PROCESS_INFORMATION pi;
	if(CreateProcess(0, strCmd.GetBuffer(0), 0,0,0,0,0,0, &suinfo, &pi))
	{
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}
}

/**
 * Runs a command shell in the current directory with a path including
 * the MingW "bin" subdirectory
 */
void CQuincyApp::RunCommandPrompt(const CString& strItem)
{
	CString strCmd(shellCommand() + " " + strItem);
	STARTUPINFO suinfo = { sizeof(STARTUPINFO) };
	PROCESS_INFORMATION pi;
	if (CreateProcess(0, strCmd.GetBuffer(0), 0,0,1,0,0,0, &suinfo, &pi))
	{
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}
}
/**
 * Runs Fluid 
 */
void CQuincyApp::RunFluid(const CString& strItem)
{
	CString strCmd(m_strQuincyBinPath + "\\fluid.exe " + strItem);
	STARTUPINFO suinfo = { sizeof(STARTUPINFO) };
	PROCESS_INFORMATION pi;
	if (CreateProcess(0, strCmd.GetBuffer(0), 0,0,0,0,0,0, &suinfo, &pi))
	{
		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}
}
void CQuincyApp::ShowLineColumn(int nLine, int nColumn)
{
	CMainFrame* pMainFrame = static_cast<CMainFrame*>(m_pMainWnd);
	pMainFrame->SetRowColumn(nLine, nColumn);
}


BOOL CQuincyApp::OnIdle(LONG lCount)
{
	if (stepping)	{
		stepping = false;
		if (m_pDebugger)
			m_pDebugger->SelectSteppingSourceLine();
	}
	CWinApp::OnIdle(lCount);

/* No Tutorial
#ifdef TYCPP
	if (m_bReadTutorial)
		ReadTutorial();
#endif
*/
	return false;
}


void CQuincyApp::EditorScreenFont(CFont* font, int ht, int wd, int wt)
{
	font->CreateFont(
		ht,						// height
		wd,						// width
		0,						// nEscapement
		0,						// nOrientation
		wt,						// nWeight
		0,						// bItalic
		0,						// bUnderline
		0,						// cStrikeOut
		DEFAULT_CHARSET,
		OUT_DEFAULT_PRECIS,
		CLIP_CHARACTER_PRECIS,
		DEFAULT_QUALITY,
		FIXED_PITCH | FF_MODERN,
		"Courier");
}

void CQuincyApp::RetabAllTextDocuments(int newtabstops)
{
	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CTextDocument* pDoc = static_cast<CTextDocument*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			CString strDocFile = GetFileName(pDoc->GetPathName());
			if (strDocFile.Right(4).CompareNoCase(".prj") != 0)
				pDoc->Retab(newtabstops);
		}
	}
}

void CQuincyApp::InvalidateAllViews(bool rebuildfont)
{
	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CTextDocument* pDoc = dynamic_cast<CTextDocument*>(pTem->GetNextDoc(dpos)); // could be project file
			if (pDoc != 0)	{
				POSITION vpos = pDoc->GetFirstViewPosition();
				ASSERT(vpos != 0);
				CTextView* pView = static_cast<CTextView*>(pDoc->GetNextView(vpos));
				ASSERT(pView != 0);
				if (rebuildfont)
					pView->RebuildFont();
				pView->Invalidate(false);
				pView->BuildContextHighlightTable();
			}
		}
	}
}

bool CQuincyApp::TestProgramChanged()
{
	if (m_bBypassChangeTest)
		return false;

	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CTextDocument* pDoc = static_cast<CTextDocument*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			CString strDocFile = GetFileName(pDoc->GetPathName());
			if (strDocFile.Right(4).CompareNoCase(".prj") != 0)	{
				if (pDoc->IsModified())	{
					if (AfxMessageBox("Program has changed. Continue?", MB_ICONQUESTION | MB_YESNO) == IDNO)	{
						OnStop();
						return true;
					}
					m_bBypassChangeTest = true;
					break;
				}
			}
		}
	}
	return false;
}

bool CQuincyApp::IsProjectFileLoaded()
{
	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CQuincyDoc* pDoc = dynamic_cast<CQuincyDoc*>(pTem->GetNextDoc(dpos));
			if (pDoc != 0)
				return true;
/*
			CTextDocument* pDoc = static_cast<CTextDocument*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			CString strDocFile = GetFileName(pDoc->GetPathName());
			if (strDocFile.Right(4).CompareNoCase(".prj") == 0)
				return true;
*/
		}
	}
	return false;
}

// Return true if any file is open
bool CQuincyApp::IsFileOpen() const
{
	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	
	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		if (dpos != 0)
				return true;
	}
	return false;
}

void CQuincyApp::OnStop()
{
	if (m_pCompiler && m_pCompiler->CompileRunning())
		m_pCompiler->Stop();
	else if (m_pDebugger != 0)
		m_pDebugger->Stop();
	else if (m_pGrep != 0)
		m_pGrep->Stop();
}

void CQuincyApp::OnGrep() 
{
	if (m_pGrep == 0)
		m_pGrep = new Grep;
	m_pGrep->OnGrep();
}

#define markup(x,y)						\
{										\
	if (x!=y)	{						\
		x=y;							\
		if (pDoc)						\
			pDoc->SetModifiedFlag();	\
	}									\
}

static bool TestChanged(const CStringArray& a1, const CStringArray& a2)
{
	if (a1.GetSize() != a2.GetSize())
		return true;
	for (int i = 0; i < a1.GetSize(); i++)
		if (a1.GetAt(i) != a2.GetAt(i))
			return true;
	return false;
}

void CQuincyApp::OnOptions() 
{
	CBuildDialog dlgBuild;
	GetArray(dlgBuild.m_strDefine, m_Defines);
	GetArray(dlgBuild.m_strInclude, m_Includes);
	dlgBuild.m_bDebugging = m_bDebugging;
	dlgBuild.m_bExceptions = m_bExceptions;
	dlgBuild.m_bRTTI = m_bRTTI;
	dlgBuild.m_bStrict = m_bStrict;
	dlgBuild.m_bC99 = m_bC99;
	dlgBuild.m_bWarnType = m_bWarnType;
	dlgBuild.m_nOptimize = m_nOptimize;
	GetArray(dlgBuild.m_strLib, m_Libs);
	dlgBuild.m_strCmdLineOptions = m_strCmdLineOptions;
	dlgBuild.m_strLinkerOptions = m_strLinkerOptions;
	dlgBuild.m_strCompiler = m_strCompiler;

	CRunOptions dlgRun;
	dlgRun.m_CommandLinePromptOption = m_CommandLinePromptOption;
	dlgRun.m_strCommandLine = m_strCommandLine;
	dlgRun.m_strRuntimeDirectory = m_strRuntimeDirectory;

	CEditorOptions dlgEditor;
	dlgEditor.m_nTabstops = m_tabstops;
	dlgEditor.m_taboption = m_taboption;
	dlgEditor.m_nMaxundos = m_maxundos;
	dlgEditor.m_AutoIndent = m_bAutoindent;
	dlgEditor.m_SyntaxColors = m_bSyntaxColors;
	dlgEditor.m_backgroundcolor = m_backgroundcolor;
	dlgEditor.m_normalcolor = m_normalcolor;
	dlgEditor.m_commentcolor = m_commentcolor;
	dlgEditor.m_stringcolor = m_stringcolor;
	dlgEditor.m_keywordcolor = m_keywordcolor;

	static int activeindex = 0;

	COptionsSheet dlgOptions("Options", 0, activeindex);

	dlgOptions.m_psh.dwFlags |= PSH_NOAPPLYNOW;

	dlgOptions.AddPage(&dlgBuild);
	dlgOptions.AddPage(&dlgRun);
	dlgOptions.AddPage(&dlgEditor);

	if (dlgOptions.DoModal() == IDOK)	{

		bool modifydoc = false;

		if (m_tabstops != dlgEditor.m_nTabstops)	{
			RetabAllTextDocuments(dlgEditor.m_nTabstops);
			m_tabstops = dlgEditor.m_nTabstops;
			InvalidateAllViews();
		}

		m_maxundos = dlgEditor.m_nMaxundos;

		if (m_bSyntaxColors != (bool) dlgEditor.m_SyntaxColors ||
				m_backgroundcolor != dlgEditor.m_backgroundcolor ||
					m_normalcolor != dlgEditor.m_normalcolor  ||
						m_commentcolor != dlgEditor.m_commentcolor ||
							m_stringcolor != dlgEditor.m_stringcolor  ||
								m_keywordcolor != dlgEditor.m_keywordcolor)	{
			m_bSyntaxColors   = dlgEditor.m_SyntaxColors;
			m_backgroundcolor = dlgEditor.m_backgroundcolor;
			m_normalcolor     = dlgEditor.m_normalcolor;
			m_commentcolor    = dlgEditor.m_commentcolor;
			m_stringcolor     = dlgEditor.m_stringcolor;
			m_keywordcolor    = dlgEditor.m_keywordcolor;
			InvalidateAllViews();
		}

		if (m_fontheight |= dlgEditor.m_SampleCode.m_fontheight)	{
			m_fontheight = dlgEditor.m_SampleCode.m_fontheight;
			m_fontwidth  = dlgEditor.m_SampleCode.m_fontwidth;
			InvalidateAllViews(true);
		}

		if (m_fontweight |= dlgEditor.m_SampleCode.m_fontweight)	{
			m_fontweight = dlgEditor.m_SampleCode.m_fontweight;
			InvalidateAllViews(true);
		}

		m_bAutoindent = dlgEditor.m_AutoIndent;
		m_taboption   = dlgEditor.m_taboption;

		// ---- these are items serialized with the project document
		CQuincyDoc* pDoc = GetProjectDocument();

		markup(m_nOptimize,dlgBuild.m_nOptimize);
		markup(m_strCmdLineOptions,dlgBuild.m_strCmdLineOptions);
		markup(m_strLinkerOptions,dlgBuild.m_strLinkerOptions);
		markup(m_CommandLinePromptOption,dlgRun.m_CommandLinePromptOption);
		markup(m_strCommandLine,dlgRun.m_strCommandLine);

		markup(m_strRuntimeDirectory,dlgRun.m_strRuntimeDirectory);
		if (!m_strRuntimeDirectory.IsEmpty() && m_strRuntimeDirectory[m_strRuntimeDirectory.GetLength()-1] != '\\')
			m_strRuntimeDirectory += '\\';

		markup(m_bDebugging,dlgBuild.m_bDebugging);
		markup(m_bExceptions,dlgBuild.m_bExceptions);
		markup(m_bRTTI,dlgBuild.m_bRTTI);
		markup(m_bStrict,dlgBuild.m_bStrict);
		markup(m_bC99,dlgBuild.m_bC99);
		markup(m_bWarnType,dlgBuild.m_bWarnType);

		CStringArray array;

		LoadArray(array,  dlgBuild.m_strDefine);
		modifydoc |= TestChanged(array,  m_Defines);
		LoadArray(array,  dlgBuild.m_strInclude);
		modifydoc |= TestChanged(array, m_Includes);
		LoadArray(array,  dlgBuild.m_strLib);
		modifydoc |= TestChanged(array, m_Libs);

		LoadArray(m_Defines,  dlgBuild.m_strDefine);
		LoadArray(m_Includes, dlgBuild.m_strInclude);
		LoadArray(m_Libs, dlgBuild.m_strLib);

		if (modifydoc && pDoc)
			pDoc->SetModifiedFlag();

		if (m_strCompiler != dlgBuild.m_strCompiler)	{
			m_strCompiler = dlgBuild.m_strCompiler;
			int len = m_strCompiler.GetLength();
			if (len && m_strCompiler[len-1] != '\\')
				m_strCompiler += '\\';
			SetCompilerPaths();
		}
/*
		if (m_strDebugger != dlgBuild.m_strDebugger)	{
			m_strDebugger = dlgBuild.m_strDebugger;
			int len = m_strDebugger.GetLength();
			if (len && m_strDebugger[len-1] != '\\')
				m_strDebugger += '\\';
			TestDebuggerPath();
		}
*/
	}
	activeindex = dlgOptions.m_activeindex;
}

// load an array of option strings from an option string ("option1;option2;...) 
void CQuincyApp::LoadArray(CStringArray& array, const CString& rstr)
{
	int len = rstr.GetLength();
	char ch = ' ';
	CString str;
	array.RemoveAll();	// start with an empty array
	for (int i = 0; i < len; i++)	{	// skip leading spaces
		if (rstr[i] == ' ')
			continue;
		while (i < len)	{	// iterate the input string
			ch = rstr[i];					// one char at a time
			// --- option terminates with ';' or at end of string
			if (ch == ';' || i == len-1)	{
				if (ch != ';')
					str += ch;
				if (!str.IsEmpty())	{
					array.Add(str);
					str.Empty();
				}
				break;
			}
			else
				str += ch;	// build option string
			i++;
		}
	}
}

// make an options string ("option1;option2;...) from an array of option strings
void CQuincyApp::GetArray(CString& atr, const CStringArray& array) const
{
	int len = array.GetSize();
	atr = "";
	for (int i = 0; i < len; i++)	{
		atr += array[i];
		if (i < len-1)
			atr += ";";
	}
}

BOOL CQuincyApp::FirstInstance()
{
	CWnd *pWndPrev, *pWndChild;

	// Determine if another window with our class name exists...
	if (pWndPrev = CWnd::FindWindow(_T("QuincyAppClass"),NULL))
	{
	  // if so, does it have any popups?
	  pWndChild = pWndPrev->GetLastActivePopup();

	  // If iconic, restore the main window
	  if (pWndPrev->IsIconic())
		 pWndPrev->ShowWindow(SW_RESTORE);

	  // Bring the main window or its popup to
	  // the foreground
	  pWndChild->SetForegroundWindow();

	  // and we are done activating the previous one.
	  return FALSE;
	}
	// First instance. Proceed as normal.
	else
		return TRUE;
}


int CQuincyApp::ExitInstance() 
{
	m_bWatchCreated = false;
	WriteProfileInt("Options", "AutoIndent", m_bAutoindent);
	WriteProfileInt("Options", "Syntax Colors", m_bSyntaxColors);

	WriteProfileInt("Options", "Background Color", m_backgroundcolor);
	WriteProfileInt("Options", "Normal Color",     m_normalcolor);
	WriteProfileInt("Options", "Keyword Color",    m_keywordcolor);
	WriteProfileInt("Options", "Comment Color",    m_commentcolor);
	WriteProfileInt("Options", "String Color",     m_stringcolor);

	WriteProfileInt("Options", "Font Height",      m_fontheight);
	WriteProfileInt("Options", "Font Width",       m_fontwidth);
//	WriteProfileString("Options", "Font Face",     m_fontface);
	WriteProfileInt("Options", "Font Weight",      m_fontweight);

	WriteProfileInt("Options", "Print Line Numbers", m_bPrintLineNos);

	WriteProfileInt("Options", "Tab Stops", m_tabstops);
	WriteProfileInt("Options", "Tabs",       m_taboption);
	WriteProfileInt("Options", "Max Undos", m_maxundos);
	WriteProfileInt("Options", "Debugging", m_bDebugging);
	WriteProfileInt("Options", "With Console", m_bWithConsole);
	WriteProfileInt("Options", "FLTK_Forms", m_bFLTK_Forms);
	WriteProfileInt("Options", "FLTK_OpenGL", m_bFLTK_OpenGL);
	WriteProfileInt("Options", "FLTK_Images", m_bFLTK_Images);
	WriteProfileInt("Options", "Exceptions", m_bExceptions);
	WriteProfileInt("Options", "RTTI", m_bRTTI);
	WriteProfileInt("Options", "Strict", m_bStrict);
	WriteProfileInt("Options", "C99", m_bC99);
	WriteProfileInt("Options", "WarnType", m_bWarnType);
	WriteProfileInt("Options", "Command Line Prompt", m_CommandLinePromptOption);
	WriteProfileInt("Options", "Optimize", m_nOptimize);

	WriteProfileString("Options", "Command Line", m_strCommandLine);
	WriteProfileString("Options", "Compiler Command Line Options", m_strCmdLineOptions);
	WriteProfileString("Options", "Linker Command Line Options", m_strLinkerOptions);

	WriteProfileInt("Options",    "Style",   m_style); 
	WriteProfileString("Options", "Command", m_command);

/* No tutorial
#ifdef TYCPP
	WriteProfileInt("Tutorial",    "Displayed", m_bTutorialDisplayed );
	WriteProfileString("Tutorial", "Current", m_strTutorial);
#endif
*/ 
	WriteProfileString("Directories", "Runtime",	  m_strRuntimeDirectory);
	WriteProfileString("Directories", "Compiler",     m_strCompiler);
	WriteProfileString("Directories", "Debugger",     m_strDebugger);

	CString strBuffer;
	strBuffer.Format ("%i:%i:%i:%i",
			m_ConsoleRect.left,
			m_ConsoleRect.top,
			m_ConsoleRect.right,
			m_ConsoleRect.bottom);

	AfxGetApp ()->WriteProfileString ("Settings", "Console Position", strBuffer);


	char path[MAX_PATH];
	_getcwd(path, MAX_PATH);
	WriteProfileString("Directories", "Current", path);

    if(bClassRegistered)
		::UnregisterClass(_T("QuincyAppClass"),AfxGetInstanceHandle());
 	return CWinApp::ExitInstance();
}

bool CQuincyApp::SelectFileAndLine(const CString& strFile, int nline)
{
	if (!strFile.IsEmpty())	{
		CDocument* pDoc = OpenDocumentFile(strFile);
		if (pDoc != 0)	{	// (user could delete the source code file before reading it)
			// ---- change focus to the selected document file
			POSITION dpos = pDoc->GetFirstViewPosition();
			ASSERT(dpos != 0);
			CEditorView* pView = static_cast<CEditorView*>(pDoc->GetNextView(dpos));
			ASSERT(pView != 0);
			pView->SetFocus();
			pView->UpdateWindow();
			pView->Invalidate();
			if (nline != 0)	{
				// ---- position text so that the specified line is current
				pView->SetLineColumn(nline, 1);
				ShowLineColumn(nline, 1);
			}
			return true;
		}
	}
	return false;
}

void CQuincyApp::SelectErrorLine(int nsel)
{
	if (nsel != -1 && m_pCompiler != 0)	{
		CString strFile;
		int line;
		if (m_pCompiler->GetMessageData(nsel, strFile, line))
			SelectFileAndLine(strFile, line);
	}
}

void CQuincyApp::SelectGrepLine(int nsel)
{
	if (m_pGrep != 0)
		m_pGrep->SelectGrepLine(nsel);
}

void CQuincyApp::OnUpdateStop(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(
			CompileRunning() || 
			(m_pGrep != 0 && m_pGrep->IsRunning()) ||
			(m_pDebugger != 0) // && m_pDebugger->CanStop())
			);
}

void CQuincyApp::SaveAllDocuments(bool prompt)
{
	POSITION tpos = GetFirstDocTemplatePosition();
	while (tpos != 0)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CDocument* pDoc = pTem->GetNextDoc(dpos);
			ASSERT(pDoc != 0);
			if (pDoc->IsModified())	{
				const CString& strPath = pDoc->GetPathName();
				if (!strPath.IsEmpty())	{
					if (prompt)	{
						CString msg("Save ");
						msg += GetFileName(strPath) + "?";
						if (AfxMessageBox(msg, MB_YESNO | MB_ICONQUESTION) != IDYES)
							continue;
					}
					pDoc->OnSaveDocument(strPath);
					pDoc->SetModifiedFlag(false);
				}
			}
		}
	}
}

void CQuincyApp::SaveOpenDocuments()
{
	POSITION tpos = GetFirstDocTemplatePosition();
	int nDocno = 0;
	CString strProfile;
	while (tpos != 0 && nDocno < maxsaveddocuments)	{
		CDocTemplate* pTem = GetNextDocTemplate(tpos);
		ASSERT(pTem != 0);
		POSITION dpos = pTem->GetFirstDocPosition();
		while (dpos != 0)	{
			CQuincyDoc* pDoc = static_cast<CQuincyDoc*>(pTem->GetNextDoc(dpos));
			ASSERT(pDoc != 0);
			CString strPath = pDoc->GetPathName();
			strProfile.Format("Document%d", ++nDocno);
			WriteProfileString("Documents", strProfile, strPath);

			CTextView* pView = GetTextView(strPath);
			ASSERT(pView != 0);
			CWnd* pWnd = pView->GetParent();
			ASSERT(pWnd != 0);
			WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
			if (pWnd->GetWindowPlacement(&wndpl))	{
				strProfile.Format("Document%d Maximized", nDocno);
				WriteProfileInt("Documents", strProfile, 
					wndpl.showCmd == SW_SHOWMAXIMIZED);

			}
		}
	}
	while (nDocno < maxsaveddocuments)	{
		strProfile.Format("Document%d", ++nDocno);
		WriteProfileString("Documents", strProfile, 0);
		strProfile.Format("Document%d Maximized", nDocno);
		WriteProfileString("Documents", strProfile, 0);
	}
}

void CQuincyApp::SaveDialogWindowPosition(const CString& strWindow, CWnd* pWnd)
{
	WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
	if (pWnd->m_hWnd != 0 && pWnd->GetWindowPlacement(&wndpl))	{
		RECT rc = wndpl.rcNormalPosition;
		WriteProfileInt(strWindow, "Left", rc.left);
		WriteProfileInt(strWindow, "Top",  rc.top);
	}
}

void CQuincyApp::RestoreDialogWindowPosition(const CString& strWindow, CWnd* pWnd)
{
	WINDOWPLACEMENT wndpl = { sizeof(WINDOWPLACEMENT) };
	if (pWnd->m_hWnd != 0)	{
		pWnd->GetWindowPlacement(&wndpl);
		int wd = wndpl.rcNormalPosition.right - wndpl.rcNormalPosition.left;
		int ht = wndpl.rcNormalPosition.bottom - wndpl.rcNormalPosition.top;
		wndpl.rcNormalPosition.left = 
			GetProfileInt(strWindow, "Left", wndpl.rcNormalPosition.left);
		wndpl.rcNormalPosition.top = 
			GetProfileInt(strWindow, "Top", wndpl.rcNormalPosition.top);
		wndpl.rcNormalPosition.right = wndpl.rcNormalPosition.left + wd;
		wndpl.rcNormalPosition.bottom = wndpl.rcNormalPosition.top + ht;
		pWnd->SetWindowPlacement(&wndpl);
	}
}

// ------- permit clearing all the breakpoints
void CQuincyApp::OnUpdateDebugClearbreakpoints(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(breakpoints.size() > 0);
}

// ------- clear all the breakpoints
void CQuincyApp::OnDebugClearbreakpoints() 
{
	breakpoints.clear();
	InvalidateAllViews();
}

void CQuincyApp::BringToTop()
{
	ASSERT(m_pMainWnd != 0);
	m_pMainWnd->SetForegroundWindow();
}
// ----- the run command
bool CQuincyApp::ExecuteRunningProgram()
{
	if (m_pDebugger != 0)
		return m_pDebugger->ExecuteRunningProgram();
	return false;
}
// ------- the step command
bool CQuincyApp::StepProgram()
{
	if (m_pDebugger != 0)
		return m_pDebugger->StepProgram();
	return false;
}

bool CQuincyApp::StepTo(const CString& strFile, int nLineNo)
{
	if (m_pDebugger != 0)
		return m_pDebugger->StepTo(strFile, nLineNo);
	steptobreakpoint = Breakpoint(strFile, nLineNo);
	return false;
}

// ------- the step out command
void CQuincyApp::StepOut()
{
	if (m_pDebugger != 0)
		m_pDebugger->StepOut();
}
// ----- the step over command
void CQuincyApp::OnDebugStepover() 
{
	if (m_pDebugger == 0 || m_pDebugger->StepOver() == false)
		m_pMainWnd->PostMessage(WM_COMMAND, ID_DEBUG_STEP);
}
// ------ disable stepping over if no document is open
void CQuincyApp::OnUpdateDebugStepover(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(false);
}
// ------ permit examining
void CQuincyApp::OnUpdateDebugExamine(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_pDebugger && !m_pDebugger->isInProgram());
}
// ------ examine command
void CQuincyApp::OnDebugExamine() 
{
	ASSERT(m_pdlgExamine != 0);
	if (GetEditorView() != 0)	{
		std::string str = GetEditorView()->SelectedText();
		if (str.size() > 0)
			m_pdlgExamine->m_strExpression = str.c_str();
	}
	m_pdlgExamine->DoModal();
}
// ------- get the value of a variable: used by watch and examine processes
void CQuincyApp::GetVariableValue(const CString& strVarName, CWnd* wnd)
{
	if (m_pDebugger != 0)
		m_pDebugger->GetVariableValue(strVarName, wnd);
}
void CQuincyApp::SetVariableValue(const CString& strVarName, const CString& strVarValue)
{
	if (m_pDebugger != 0)
		m_pDebugger->SetVariableValue(strVarName, strVarValue);
}

void CQuincyApp::CreateWatchWindow()
{
	ASSERT(m_pdlgWatch != 0);
	if (m_bWatchCreated != true)	{
		m_pdlgWatch->Create(IDD_WATCH);
		m_bWatchCreated = true;
	}
}

void CQuincyApp::PostWatchList()
{
	if (m_pDebugger && m_pdlgWatch && m_bWatchCreated)	{
		int ct = m_pdlgWatch->GetWatchCount();
		CString* wnames = m_pdlgWatch->GetWatchNames();
		m_pDebugger->SetWatchExpressions(wnames, ct);
	}
}

// --- called from CQuincyDoc class's Serialize function
void CQuincyApp::SerializeProjectOptions(CArchive& ar, int nSig, int variant)
{
	if (ar.IsStoring())	{
		ar << m_bDebugging;
		ar << m_bExceptions;
		ar << m_bRTTI;
		if (nSig != 9797)	{
			ar << m_bStrict;
			if (nSig == 2002 || nSig == 2005)	{
				ar << m_nOptimize;
				ar << m_strCmdLineOptions;
				ar << m_CommandLinePromptOption;
				ar << m_strCommandLine;
				ar << m_strRuntimeDirectory;
				if (nSig == 2005)	{
					ar << m_bC99;
					ar << m_bWarnType;
					ar << m_strLinkerOptions;
				}
			}
		}
	}
	else	{
		ar >> m_bDebugging;
		ar >> m_bExceptions;
		ar >> m_bRTTI;
		if (nSig != 9797)	{
			ar >> m_bStrict;
			if (nSig == 2002 || nSig == 2005)	{
				ar >> m_nOptimize;
				ar >> m_strCmdLineOptions;
				ar >> m_CommandLinePromptOption;
				ar >> m_strCommandLine;
				ar >> m_strRuntimeDirectory;
				if (nSig == 2005) {
					ar >> m_bC99;
					// C99 must always be on in GCC 3.4.5
					if (theApp.compilerVersion() == CString("3.4.5"))
						m_bC99 = true;
					
					ar >> m_bWarnType;
					ar >> m_strLinkerOptions;
				}					
			}
		}
	}
	SerializeOptions(ar, m_Defines);
	SerializeOptions(ar, m_Includes);
	SerializeOptions(ar, m_Libs);
}
// --- called only from above
void CQuincyApp::SerializeOptions(CArchive& ar, CStringArray& array)
{
	if (ar.IsStoring())	{
		int len = array.GetSize();
		ar << len;
		for (int i = 0; i < len; i++)
			ar << array[i];
	}
	else	{
		array.RemoveAll();
		int len;
		ar >> len;
		while (len--)	{
			CString str;
			ar >> str;
			array.Add(str);
		}
	}
}

bool CQuincyApp::IsOnCDROM(const CString& strFileSpec)
{
	if (strFileSpec.GetLength() < 3)
		return false;
	char root[4];
	for (int i = 0; i < 3; i++)
		root[i] = strFileSpec[i];
	root[i] = '\0';
	return GetDriveType(root) == DRIVE_CDROM;
}

///////////////// breakpoint methods //////////////////////////

// ------ adjust breakpoints when user inserts or deletes lines
void CQuincyApp::AdjustTextLine(const CString& strFile, int nLineno, int nAdjust)
{
	std::vector<Breakpoint> dels;
	std::vector<Breakpoint> inss;

	std::set<Breakpoint>::iterator iter;
	// --- if deleting a line with a breakpoint, delete the breakpoint
	if (nAdjust < 0)	{
		Breakpoint fr(strFile, nLineno+1);
		iter = breakpoints.find(fr);
		if (iter != breakpoints.end())
			breakpoints.erase(iter);
	}
	// --- find the breakpoints for this file greater than the current line
	Breakpoint fr(strFile, nLineno);
	iter = std::lower_bound(breakpoints.begin(), breakpoints.end(), fr);
	while (iter != breakpoints.end() &&
			(*iter).m_strFile.CompareNoCase(strFile) == 0)	{
		Breakpoint fr = *iter;
		dels.push_back(fr);
		fr.m_nLineNo += nAdjust;
		inss.push_back(fr);
		iter++;
	}
	std::vector<Breakpoint>::iterator vfr;
	for (vfr = dels.begin(); vfr != dels.end(); vfr++)	{
		iter = breakpoints.find(*vfr);
		if (iter != breakpoints.end())
			breakpoints.erase(iter);
	}
	for (vfr = inss.begin(); vfr != inss.end(); vfr++)
		breakpoints.insert(*vfr);
}

// --- set or clear a breakpoint
void CQuincyApp::ToggleBreakpoint(const CString& strFile, int nLineNo)
{
	Breakpoint fr(GetFileName(strFile), nLineNo);
	std::set<Breakpoint>::iterator iter = breakpoints.find(fr);
	if (iter == breakpoints.end())
		breakpoints.insert(fr);
	else	{
		breakpoints.erase(iter);
		if (m_pDebugger != 0)
			m_pDebugger->ClearBreakpoint(fr);
	}
}

void CQuincyApp::AddBreakpoint(const CString& strFile, int nLineNo)
{
	Breakpoint fr(GetFileName(strFile), nLineNo);
	std::set<Breakpoint>::iterator iter = breakpoints.find(fr);
	if (iter == breakpoints.end())
		breakpoints.insert(fr);
}

// ------ test for a breakpoint set in a file at a line number
bool CQuincyApp::IsBreakpoint(const CString& strFile, int nLineno)
{
	Breakpoint fr(strFile, nLineno);
	std::set<Breakpoint>::iterator iter = breakpoints.find(fr);
	bool bBrk = iter != breakpoints.end();
	return bBrk;
}


Breakpoint CQuincyApp::SteptoBreakpoint()
{
	Breakpoint pt = steptobreakpoint;
	steptobreakpoint = Breakpoint();
	return pt;
}

void CQuincyApp::OnDebugWatch() 
{
	CreateWatchWindow();
	m_pdlgWatch->ShowWindow(SW_SHOW);
	m_pdlgWatch->SetFocus();
	if (m_pdlgWatch->GetWatchCount() == 0)	{
		if (GetEditorView() != 0)	{
			std::string str = GetEditorView()->SelectedText();
			m_pdlgWatch->AddSelectedWatch(str);
		}
		else
			m_pdlgWatch->AddWatch();
	}
}

bool CQuincyApp::StopDebugging()
{
	if (m_pDebugger != 0)	{
		if (AfxMessageBox("This stops the debugger. Continue?", MB_ICONQUESTION | MB_YESNO) == IDYES)
			m_pDebugger->Stop();
		else
			return false;
	}
	return true;
}

void CQuincyApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	// --- display compiler version in about dialog
	if (m_bCompilerIsInstalled)
		aboutDlg.m_strCompilerVersion = "MinGW GCC version " + m_strVersion;

	// display operating version in about dialog
	CString version;
	// Test for the specific product family.
	switch (osversion.dwPlatformId)
	{
	case VER_PLATFORM_WIN32_NT:
		if ( osversion.dwMajorVersion == 6 )
			version = "VISTA";
		else if ( osversion.dwMajorVersion == 5 )
		{
			if ( osversion.dwMinorVersion == 2 )
				version = "Server 2003";
			else if ( osversion.dwMinorVersion == 1 )
				version = "XP";
			else if ( osversion.dwMinorVersion == 0 )
				version = "2000";
			else
				version.Format("ID: %ld-%d.%d", osversion.dwPlatformId, 
										        osversion.dwMajorVersion,
												osversion.dwMinorVersion);

		}
		else if ( osversion.dwMajorVersion <= 4 )
			version = "NT";
		else
			version.Format("ID: %ld-%d.%d", osversion.dwPlatformId, 
									        osversion.dwMajorVersion,
											osversion.dwMinorVersion);
	break;
	case VER_PLATFORM_WIN32_WINDOWS:
         if (osversion.dwMajorVersion == 4)
		 {
			if ( osversion.dwMinorVersion == 0)
				version = "95";
			else if ( osversion.dwMinorVersion == 10)
				version = "98";
			else if ( osversion.dwMinorVersion == 90)
				version = "ME";
			else
				version.Format("ID: %ld-%d.%d", osversion.dwPlatformId, 
			                            osversion.dwMajorVersion,
										osversion.dwMinorVersion);
		 }
    break;
	default:
		version.Format("ID: %ld-%d.%d", osversion.dwPlatformId, 
			                            osversion.dwMajorVersion,
										osversion.dwMinorVersion);
	break;
	}

	aboutDlg.m_strOSVersion.Format("Windows %s", version);
	aboutDlg.DoModal();
}

/**
 * Return a shell appropriate to the current windows version
 */
CString CQuincyApp::shellCommand() const
{
	// Test for the specific product family.
	if (osversion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) // Windows 95, 98 or ME
		return "command.com";
	else
		return "cmd.exe";
}

void CQuincyApp::OnUpdateGrep(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bGrepIsInstalled);
}


/* No tutorial since Quincy 2005 v1.1
void CQuincyApp::OnUpdateTycpp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bIsTutorial);
}
*/

void CQuincyApp::OnHelp() 
{
	ShellExecute(0, "open", (m_strQuincyInstallPath + "\\quincy2005.htm").GetBuffer(0), 0, 0, SW_SHOW);
}

void CQuincyApp::OnUpdateHelp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bBrowser);
}


void CQuincyApp::OnProgrammerHelp() 
{
	ShellExecute(0, "open", (m_strQuincyInstallPath + "\\programmerGuide.htm").GetBuffer(0), 0, 0, SW_SHOW);
}

void CQuincyApp::OnUpdateProgrammerHelp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bBrowser);
}

// OnTycpp now calls simple program examples
void CQuincyApp::OnTycpp() 
{
	ShellExecute(0, "open", (m_strQuincyInstallPath + "\\tutorial.htm").GetBuffer(0), 0, 0, SW_SHOW);
}

void CQuincyApp::OnUpdateTycpp(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bBrowser);
}
void CQuincyApp::OnResourceeditor() 
{
	RunResourceEditor();
}
void CQuincyApp::OnUpdateResourceeditor(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bWEditResIsInstalled);
}

void CQuincyApp::OnToolsFluid() 
{
	RunFluid();
}
void CQuincyApp::OnUpdateToolsFluid(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(m_bFluidIsInstalled);
}
void CQuincyApp::OnToolsCommandPrompt() 
{
	RunCommandPrompt();
}
void CQuincyApp::OnUpdateToolsCommandPrompt(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(true);
}
void CQuincyApp::OnFileOpen() 
{
	static char BASED_CODE szFilter[] = 
			"Quincy files (*.cpp, *.cxx, *.cc, *.c,*.h,*.prj,*.rc)"
			"|*.cpp; *.cxx; *.cc; *.c; *.h; *.prj; *.rc|"
			"All files (*.*)"
			"|*.*|"
			"|";

	CFileDialog dlg(true,
					0,
					0,
					OFN_HIDEREADONLY	 | 
					OFN_FILEMUSTEXIST	 |
					OFN_ALLOWMULTISELECT |
					OFN_NOCHANGEDIR		 |
					OFN_ENABLESIZING	 |
					OFN_PATHMUSTEXIST, 
					szFilter,
					m_pMainWnd
					);
	// Open in project directory if it exists
	dlg.GetOFN().lpstrInitialDir = GetProjectPath();

	// Provide space for a list with a max of at least 50 file names.
	CString fnameBuffer;
	const bufSize = 50 *(_MAX_PATH + 1) + 1;

	dlg.GetOFN().nMaxFile = bufSize;
	dlg.GetOFN().lpstrFile = fnameBuffer.GetBuffer(bufSize);

	if (dlg.DoModal() == IDOK)
	{
		POSITION pos ( dlg.GetStartPosition() );
		while( pos )
			OpenDocumentFile(dlg.GetNextPathName(pos));

	}
}

void CQuincyApp::SetMenuCommand(int id)
{
	CMenu* pCMenu = ((CMainFrame*)(m_pMainWnd))->GetMenu();
	pCMenu->CheckMenuItem(id, MF_CHECKED);
}
void CQuincyApp::ResetMenuCommand(int id)
{
	CMenu* pCMenu = ((CMainFrame*)(m_pMainWnd))->GetMenu();
	pCMenu->CheckMenuItem(id, MF_UNCHECKED);
}

void CQuincyApp::OnFilePrintSetup() 
{
	CQuincyPrintDialog pd(true);
	pd.printlinenumbers = m_bPrintLineNos;
	if (DoPrintDialog(&pd) == IDOK)
		m_bPrintLineNos = pd.printlinenumbers;
}

void CQuincyApp::SetBuildingCPP(bool bSet)
{
	ASSERT(m_pCompiler != 0);
	m_pCompiler->SetBuildingCPP(bSet == true);
}

bool CQuincyApp::CompileRunning() const
{
	return m_pCompiler == 0 ? false : m_pCompiler->CompileRunning();
}

void CQuincyApp::CreateGdbConsole()
{
	ASSERT(m_pdlgGdbConsole != 0);
	if (m_bGdbConsoleCreated != true)	{
		m_pdlgGdbConsole->Create(IDD_GDBCONSOLE);
		m_bGdbConsoleCreated = true;
	}
}

void CQuincyApp::OnViewGdbconsole() 
{CreateGdbConsole();
	m_pdlgGdbConsole->ShowWindow(SW_SHOW);
	m_pdlgGdbConsole->SetFocus();
}

void CQuincyApp::DisplayGdbText(char* txt)
{
	if (m_pdlgGdbConsole != 0)	{
		if (m_bGdbConsoleCreated)	{
			char* cp = txt;
			while (*cp)	{
				if (*cp == '\t')
					*cp = ' ';
				cp++;
			}
			if (!appendnexttext)
				m_pdlgGdbConsole->AddString(txt);
			else	{
				m_pdlgGdbConsole->AppendString(" ");
				m_pdlgGdbConsole->AppendString(txt);
				appendnexttext = false;
			}
		}
	}
}

void CQuincyApp::ClearGdbConsole()
{
	if (m_pdlgGdbConsole != 0)
		if (m_bGdbConsoleCreated)
			m_pdlgGdbConsole->ClearConsole();
}

// --- put quotes around a file specification that has one or more spaces
//     so the file specification can be used on a command line
CString CQuincyApp::Enquote(const CString& str) const
{
	if (str[0] == '"' || str.Find(' ') == -1)
		return str;		// file spec is already quoted or has no spaces
	CString qstr("\"" + str);
	// if the spec ends with backslash, add another backslash 
	if (qstr[qstr.GetLength()-1] == '\\')
		qstr += "\\";
	qstr += "\"";
	return qstr;
}

bool CQuincyApp::SelectFolder(const char* title, CString* strpath)
{
	bool rtn = false;
	std::string ttl("Select Folder for ");
	ttl += title;
	BROWSEINFO info = {
		0,
		0,
		0,
		ttl.c_str(),
		BIF_EDITBOX,
		0,
		0
	};
	LPITEMIDLIST idlist;
	idlist = SHBrowseForFolder(&info);
	if (idlist != 0)	{
		char path[MAX_PATH];
		if (SHGetPathFromIDList(idlist, path))	{
			*strpath = path;
			rtn = true;
		}
	}
	IMalloc* im = 0;
	if (SUCCEEDED(SHGetMalloc(&im)))	{
		im->Free(idlist);
		im->Release();
	}
	return rtn;
}

void CQuincyApp::HtmlHelp(char* htmfile, int name)
{
	CString help(theApp.QuincyHtmlPath() + htmfile+".htm");

	char path[MAX_PATH];
	int rtn = reinterpret_cast<int>(FindExecutable(help.GetBuffer(0), 0, path));
	CString exe(path);
	exe += " ";
	exe += help;

	CString exep;
	if (name)
		exep.Format("%s#%02d", exe.GetBuffer(0), name);
	else
		exep = exe;

	if (rtn > 32)	{
		STARTUPINFO su = {sizeof(STARTUPINFO)};
		
		PROCESS_INFORMATION pi;

		CreateProcess(	
					0, 
					exep.GetBuffer(0), 
					0, 
					0, 
					FALSE, 
					CREATE_NEW_PROCESS_GROUP,
					0,
					0,
					&su,
					&pi);

	}
	else
		ShellExecute(0, "open", help.GetBuffer(0), 0, 0, SW_SHOW);
}

void CQuincyApp::OnUpdateProperties(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(IsProjectFileLoaded());
}

void CQuincyApp::OnProperties() 
{
	CQuincyDoc* pDoc = GetProjectDocument();
	if (pDoc != 0)
		pDoc->DoOnProperties();
}

void CQuincyApp::CloseErrorLog()
{
	if (m_pCompiler != 0) 
		m_pCompiler->CloseErrorLog();
}
