// QuincyView.h : interface of the CQuincyView class
//
/////////////////////////////////////////////////////////////////////////////
#ifndef CQUINCYVIEW_H
#define CQUINCYVIEW_H

class CQuincyDoc;

class CQuincyView : public CListView
{
	DWORD m_nExitCode;
	CString m_strTargetFile;
	bool m_bDoLink;
	CStringArray m_IncludesChecked;	// #include files tested for currency
	void MakeSubdirectories(const CString& strPath);
protected: // create from serialization only
	CQuincyView();
	DECLARE_DYNCREATE(CQuincyView)

// Attributes
public:
	CQuincyDoc* GetDocument();
	int GetItemCount();
	int GetSelectedCount();
	bool IncludesAreNewer(CString& strSrcFile, CString& strObjFile);
	bool UpdateSourceFile(CString& strSrcFile);
	void BuildProject(bool bDoExecute, bool bDoStep);
	void MakeTargetName();
	bool TargetIsCurrent(bool bForceRebuild = false);
	bool CanExecuteProgram(bool bDoStep);

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQuincyView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CQuincyView();
	void DoRun() { OnRun(); }
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CQuincyView)
	afx_msg void OnBuild();
	afx_msg void OnBuildAll();
	afx_msg void OnDeleteFile();
	afx_msg void OnInsertFile();
	afx_msg void OnHeaderOpen();
	afx_msg void OnRun();
	afx_msg void OnUpdateDelete(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBuild(CCmdUI* pCmdUI);
	afx_msg void OnUpdateExecute(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnSelectfile();
	afx_msg void OnUpdateSelectfile(CCmdUI* pCmdUI);
	afx_msg void OnDebugStep();
	afx_msg void OnUpdateDebugStep(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDebugStepover(CCmdUI* pCmdUI);
	afx_msg void OnUpdateDebugSteptocursor(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAll(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
public:
};

#ifndef _DEBUG  // debug version in QuincyView.cpp
inline CQuincyDoc* CQuincyView::GetDocument()
   { return (CQuincyDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
inline int CQuincyView::GetItemCount()
{
	return GetListCtrl().GetItemCount();
}

inline int CQuincyView::GetSelectedCount()
{
	return GetListCtrl().GetSelectedCount();
}

#endif
