// TextDocument.cpp : implementation file
//

#include "stdafx.h"
#include "Quincy.h"
#include "TextDocument.h"
#include "debugger.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextDocument

IMPLEMENT_DYNCREATE(CTextDocument, CEditorDoc)

CTextDocument::CTextDocument()
{
}

CTextDocument::~CTextDocument()
{
}

BEGIN_MESSAGE_MAP(CTextDocument, CEditorDoc)
	//{{AFX_MSG_MAP(CTextDocument)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnUpdateFilePrint)
	ON_UPDATE_COMMAND_UI(ID_DELETE_FILE, OnUpdateDeleteFile)
	ON_UPDATE_COMMAND_UI(ID_INSERT_FILE, OnUpdateInsertFile)
	ON_UPDATE_COMMAND_UI(ID_EXECUTE, OnUpdateExecute)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_BREAKPOINT, OnUpdateDebugBreakpoint)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEP, OnUpdateDebugStep)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPOVER, OnUpdateDebugStepover)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPTOCURSOR, OnUpdateDebugSteptocursor)
	ON_UPDATE_COMMAND_UI(ID_DEBUG_STEPOUTOFFUNCTION, OnUpdateDebugStepoutoffunction)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextDocument diagnostics

#ifdef _DEBUG
void CTextDocument::AssertValid() const
{
	CEditorDoc::AssertValid();
}

void CTextDocument::Dump(CDumpContext& dc) const
{
	CEditorDoc::Dump(dc);
}
#endif //_DEBUG


// --- files you can compile
bool CTextDocument::IsSourceFile()
{
	CString& rstrPath = const_cast<CString&>(GetPathName());
	return rstrPath.Right(2).CompareNoCase(".c")   == 0 ||
		   rstrPath.Right(3).CompareNoCase(".rc")  == 0 ||
		   rstrPath.Right(3).CompareNoCase(".cc")  == 0 ||
		   rstrPath.Right(4).CompareNoCase(".cxx") == 0 ||
		   rstrPath.Right(4).CompareNoCase(".cpp") == 0;
}

// --- files you can set breakpoints in
bool CTextDocument::IsExecutableSourceFile()
{
	CString& rstrPath = const_cast<CString&>(GetPathName());
	return rstrPath.Right(2).CompareNoCase(".c")   == 0 ||
		   rstrPath.Right(2).CompareNoCase(".h")   == 0 ||
		   rstrPath.Right(3).CompareNoCase(".cc")  == 0 ||
		   rstrPath.Right(4).CompareNoCase(".cxx") == 0 ||
		   rstrPath.Right(4).CompareNoCase(".cpp") == 0;
}

/////////////////////////////////////////////////////////////////////////////
// CTextDocument commands

void CTextDocument::OnUpdateFilePrint(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(true);	
}

void CTextDocument::OnUpdateDeleteFile(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(false);	
}

void CTextDocument::OnUpdateInsertFile(CCmdUI* pCmdUI) 
{
    pCmdUI->Enable(false);	
}

void CTextDocument::OnUpdateExecute(CCmdUI* pCmdUI) 
{
	if (theApp.CompileRunning() || !theApp.CanCompile() || theApp.IsLibraryTarget() || theApp.IsDLLTarget())	{
		pCmdUI->Enable(false);
		return;
	}
	Debugger* pDebugger = theApp.GetDebugger(false);
	if (pDebugger != 0)	{
		OnUpdateDebugWatch(pCmdUI);
		return;
	}
	pCmdUI->Enable(theApp.GetProjectView() || IsSourceFile());
}

void CTextDocument::OnUpdateDebugBreakpoint(CCmdUI* pCmdUI) 
{
	if (theApp.CompileRunning() || !IsExecutableSourceFile() || !theApp.CanCompile() || theApp.IsLibraryTarget() || theApp.IsDLLTarget())	{
		pCmdUI->Enable(false);
		return;
	}
	Debugger* pDebugger = theApp.GetDebugger(false);
	pCmdUI->Enable(pDebugger == 0 || !pDebugger->isInProgram());
}

void CTextDocument::OnUpdateDebugStep(CCmdUI* pCmdUI) 
{
	OnUpdateDebugWatch(pCmdUI);
}

void CTextDocument::OnUpdateDebugStepover(CCmdUI* pCmdUI) 
{
	OnUpdateDebugWatch(pCmdUI);
}

void CTextDocument::OnUpdateDebugWatch(CCmdUI* pCmdUI) 
{
	if (theApp.CompileRunning() || !theApp.CanCompile() || theApp.IsLibraryTarget() || theApp.IsDLLTarget())	{
		pCmdUI->Enable(false);
		return;
	}
	Debugger* pDebugger = theApp.GetDebugger(false);
	pCmdUI->Enable(pDebugger == 0 || !pDebugger->isInProgram());
}

void CTextDocument::OnUpdateDebugSteptocursor(CCmdUI* pCmdUI) 
{
	if (theApp.CompileRunning() || !IsExecutableSourceFile() || !theApp.CanCompile() || theApp.IsLibraryTarget() || theApp.IsDLLTarget())	{
		pCmdUI->Enable(false);
		return;
	}
	Debugger* pDebugger = theApp.GetDebugger(false);
	pCmdUI->Enable(pDebugger == 0 || !pDebugger->isInProgram());
}

void CTextDocument::OnUpdateDebugStepoutoffunction(CCmdUI* pCmdUI) 
{
	Debugger* pDebugger = theApp.GetDebugger(false);
	pCmdUI->Enable(pDebugger != 0 && !pDebugger->isInProgram());
}
