// TextView.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CTextView view

#include "EditorView.h"

class CTextView : public CEditorView
{
	CFont newfont;
	CString m_strExe;

	bool DoCompile(bool bDoLink, bool bDoExecute, bool bDoStep = false);
	bool DoLink(); 
	void WriteMarginBitmap(int nRow, CBitmap& bm);
	CString SourceCodeFileName();
	int RelativeRow(int nLineno);
	bool CanBuild();
	bool IsSourceFile();
	bool BuildIfNeeded(bool bStep);
	friend class CQuincyApp;
protected:
	CTextView();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CTextView)

// Attributes
public:

// Operations
public:
	void SetBreakpointDisplay(int nLineNo, bool bOnOff);
	void SetPCBreakpointDisplay(int nLineNo);
	void SetProgramCounterDisplay(int nLineNo, bool bOnOff);
	void DrawMargins();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CTextView)
	protected:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CTextView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	// Generated message map functions
protected:
	//{{AFX_MSG(CTextView)
	afx_msg void OnBuild();
	afx_msg void OnBuildall();
	afx_msg void OnCompile();
	afx_msg void OnLink();
	afx_msg void OnRun();
	afx_msg void OnDebugBreakpoint();
	afx_msg void OnDebugStep();
	afx_msg void OnDebugSteptocursor();
	afx_msg void OnUpdateBuild(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBuildAll(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCompile(CCmdUI* pCmdUI);
	afx_msg void OnUpdateLink(CCmdUI* pCmdUI);
	afx_msg void OnUpdateFileSaveAll(CCmdUI* pCmdUI);
	afx_msg void OnDebugStepoutoffunction();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
